/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;

public class EncodingSizeCalculator {
    private static final int DEFAULT_CHAR_ENCODING_SIZE = 1;
    int offset = 0;
    char[] input;
    int[] sizes;
    final CharsetEncoder encoder;
    final CharBuffer buffer;
    BitSet calculated;
    int cacheStart;
    int cacheEnd;
    int[] cache;
    boolean strict = false;

    public EncodingSizeCalculator(String encoding) {
        this(encoding, false);
    }

    public EncodingSizeCalculator(String encoding, boolean strict) {
        Charset charset = Charset.forName(encoding);
        this.encoder = charset.newEncoder();
        this.buffer = CharBuffer.allocate(1);
        this.calculated = new BitSet(1);
        this.clear();
        this.strict = strict;
    }

    public void setInput(char[] input) {
        this.setInput(input, 0, input.length);
    }

    private void setInput(char[] input, int start, int count) {
        this.clear();
        this.offset = start;
        this.input = new char[count];
        System.arraycopy(input, start, this.input, 0, count);
        this.sizes = new int[count];
        if (this.calculated.size() < count) {
            this.calculated = new BitSet(count);
        }
    }

    private void clear() {
        this.input = null;
        this.sizes = null;
        this.offset = -1;
        this.buffer.clear();
        this.calculated.clear();
        this.cacheStart = -1;
        this.cacheEnd = Integer.MAX_VALUE;
        this.cache = null;
    }

    public int getByteSize(int start, int end) throws CharacterCodingException {
        return this.getByteSize(start, end, false);
    }

    public int getByteSize(int start, int end, boolean useCache) throws CharacterCodingException {
        int sum;
        block7: {
            int i;
            block6: {
                if (start == end) {
                    return 0;
                }
                this.fillSize(start -= this.offset, end -= this.offset);
                if (useCache) {
                    this.caching(start, end);
                }
                sum = 0;
                if (this.cache != null && end > this.cacheStart && this.cacheEnd > start) break block6;
                int i2 = start;
                while (i2 < end) {
                    sum += this.sizes[i2];
                    ++i2;
                }
                break block7;
            }
            if (start <= this.cacheStart) {
                i = start;
                while (i < this.cacheStart) {
                    sum += this.sizes[i];
                    ++i;
                }
            }
            sum += this.cache[Math.min(this.cacheEnd, end) - this.cacheStart] - this.cache[Math.max(this.cacheStart, start) - this.cacheStart];
            if (this.cacheEnd > end) break block7;
            i = this.cacheEnd;
            while (i < end) {
                sum += this.sizes[i];
                ++i;
            }
        }
        return sum;
    }

    private void caching(int start, int end) {
        if (this.cache != null && this.cacheStart <= start && end <= this.cacheEnd) {
            return;
        }
        if (this.cache != null && this.cacheStart <= start && start <= this.cacheEnd && this.cacheEnd <= end) {
            int tempStart = this.cacheStart;
            int tempEnd = end;
            int[] tempCache = new int[tempEnd - tempStart + 1];
            System.arraycopy(this.cache, 0, tempCache, 0, this.cache.length);
            int j = this.cache.length;
            int i = this.cacheEnd;
            while (i < tempEnd) {
                tempCache[j] = tempCache[j - 1] + this.sizes[i];
                ++j;
                ++i;
            }
            this.cacheStart = tempStart;
            this.cacheEnd = tempEnd;
            this.cache = tempCache;
            return;
        }
        this.cache = new int[end - start + 1];
        this.cacheStart = start;
        this.cacheEnd = end;
        int j = 1;
        int i = this.cacheStart;
        while (i < this.cacheEnd) {
            this.cache[j] = this.cache[j - 1] + this.sizes[i];
            ++j;
            ++i;
        }
    }

    private void fillSize(int start, int end) throws CharacterCodingException {
        int i = this.calculated.nextClearBit(start);
        while (i < end) {
            this.buffer.put(this.input[i]);
            this.buffer.flip();
            try {
                this.sizes[i] = this.encoder.encode(this.buffer).remaining();
            }
            catch (CharacterCodingException e) {
                if (this.strict) {
                    throw e;
                }
                this.sizes[i] = 1;
            }
            this.buffer.clear();
            this.calculated.set(i);
            i = this.calculated.nextClearBit(i + 1);
        }
    }
}

