/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import com.diquest.ir.util.common.TimedFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FileUtil {
    public static final String NONE_EXTENSION = "NONE";

    public static final boolean deleteDir(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children == null) {
                return false;
            }
            int i = 0;
            while (i < children.length) {
                boolean success = FileUtil.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static final String getUpperExtension(File f) {
        if (f.isFile()) {
            String n = f.getName();
            int idx = n.lastIndexOf(46);
            if (idx < 0) {
                return null;
            }
            String ext = n.substring(idx + 1).trim();
            if (ext.equals("")) {
                return null;
            }
            return ext.toUpperCase();
        }
        return null;
    }

    public static final String getUpperExtension(String n) {
        int idx = n.lastIndexOf(46);
        if (idx < 0) {
            return NONE_EXTENSION;
        }
        String ext = n.substring(idx + 1).trim();
        if (ext.equals("")) {
            return null;
        }
        return ext.toUpperCase();
    }

    public static final String getUpperPrefix(String n) {
        int idx = n.indexOf(46);
        if (idx < 0) {
            return null;
        }
        String ext = n.substring(0, idx).trim();
        if (ext.equals("")) {
            return null;
        }
        return ext.toUpperCase();
    }

    public static final File mkdirs(String path) {
        File dirs = new File(path);
        dirs.mkdirs();
        return dirs;
    }

    public static final void mkdirs(File[] dirs) {
        int i = 0;
        while (i < dirs.length) {
            dirs[i].mkdirs();
            ++i;
        }
    }

    public static final void copyFile(File in, File out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        int maxCount = 0x1C00000;
        long size = sourceChannel.size();
        long position = 0L;
        while (position < size) {
            position += sourceChannel.transferTo(position, maxCount, destinationChannel);
        }
        sourceChannel.close();
        destinationChannel.close();
    }

    public static final void copyFile(String in, String out) throws IOException {
        FileChannel sourceChannel = new FileInputStream(in).getChannel();
        FileChannel destinationChannel = new FileOutputStream(out).getChannel();
        int maxCount = 0x1C00000;
        long size = sourceChannel.size();
        long position = 0L;
        while (position < size) {
            position += sourceChannel.transferTo(position, maxCount, destinationChannel);
        }
        sourceChannel.close();
        destinationChannel.close();
    }

    public static final boolean isEmpty(String filename) {
        return new File(filename).length() == 0L;
    }

    public static final void copyDir(File sourceDir, File targetDir) throws IOException {
        targetDir.mkdirs();
        File[] files = sourceDir.listFiles();
        if (files == null) {
            throw new IOException("The pathname does not denote a directory, or an I/O error has been occurred: " + sourceDir.getAbsolutePath());
        }
        int i = 0;
        while (i < files.length) {
            File sourceFile = files[i];
            File targetFile = new File(targetDir.getAbsolutePath(), sourceFile.getName());
            if (sourceFile.isDirectory()) {
                FileUtil.copyDir(sourceFile, targetFile);
            } else {
                FileUtil.copyFile(sourceFile, targetFile);
            }
            ++i;
        }
    }

    public static final boolean deleteFiles(File dir) {
        if (!dir.exists()) {
            return true;
        }
        if (dir.isDirectory()) {
            String[] children = dir.list();
            if (children == null) {
                return false;
            }
            int i = 0;
            while (i < children.length) {
                boolean success = new File(dir, children[i]).delete();
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static BufferedReader getBufferedReader(File file) throws FileNotFoundException {
        return FileUtil.getBufferedReader(file.getPath());
    }

    public static BufferedReader getBufferedReader(String fileName) throws FileNotFoundException {
        BufferedReader br;
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex < 0) {
            return new BufferedReader(new FileReader(fileName));
        }
        String extension = fileName.substring(extIndex + 1);
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), extension));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedReader(new FileReader(fileName));
        }
        return br;
    }

    public static BufferedWriter getBufferedWriter(File file) throws IOException {
        return FileUtil.getBufferedWriter(file.getPath());
    }

    public static BufferedWriter getBufferedWriter(String fileName) throws IOException {
        BufferedWriter br;
        int extIndex = fileName.lastIndexOf(46);
        if (extIndex < 0) {
            return new BufferedWriter(new FileWriter(fileName));
        }
        String extension = fileName.substring(extIndex + 1);
        try {
            br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), extension));
        }
        catch (UnsupportedEncodingException e) {
            return new BufferedWriter(new FileWriter(fileName));
        }
        return br;
    }

    public static File[] sortWithName(File[] files) {
        Arrays.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f1.getName().compareTo(f2.getName());
            }
        });
        return files;
    }

    public static List sortWithName(List files) {
        Collections.sort(files, new Comparator(){

            public int compare(Object o1, Object o2) {
                File f1 = (File)o1;
                File f2 = (File)o2;
                return f1.getName().compareTo(f2.getName());
            }
        });
        return files;
    }

    public static File[] sortWithLastModifiedTime(File[] files) {
        Object[] tfiles = new TimedFile[files.length];
        int i = 0;
        while (i < files.length) {
            tfiles[i] = new TimedFile(files[i]);
            ++i;
        }
        Arrays.sort(tfiles);
        i = 0;
        while (i < files.length) {
            files[i] = ((TimedFile)tfiles[i]).getFile();
            ++i;
        }
        return files;
    }

    public static List sortWithLastModifiedTime(List files) {
        Object[] tfiles = new TimedFile[files.size()];
        int i = 0;
        while (i < files.size()) {
            tfiles[i] = new TimedFile((File)files.get(i));
            ++i;
        }
        Arrays.sort(tfiles);
        ArrayList<File> rfiles = new ArrayList<File>();
        int i2 = 0;
        while (i2 < files.size()) {
            rfiles.add(((TimedFile)tfiles[i2]).getFile());
            ++i2;
        }
        return rfiles;
    }

    public static File[] convert(String[] fileNames) {
        File[] fs = new File[fileNames.length];
        int i = 0;
        while (i < fs.length) {
            fs[i] = new File(fileNames[i]);
            ++i;
        }
        return fs;
    }

    public static String[] getAbsolutePath(File[] files) {
        String[] fs = new String[files.length];
        int i = 0;
        while (i < fs.length) {
            fs[i] = files[i].getAbsolutePath();
            ++i;
        }
        return fs;
    }

    public static String[] getName(File[] files) {
        String[] fs = new String[files.length];
        int i = 0;
        while (i < fs.length) {
            fs[i] = files[i].getName();
            ++i;
        }
        return fs;
    }

    public static String[] getCanonicalPath(File[] files) throws IOException {
        String[] fs = new String[files.length];
        int i = 0;
        while (i < fs.length) {
            fs[i] = files[i].getCanonicalPath();
            ++i;
        }
        return fs;
    }

    public static String[] getFileList(String directory) {
        File file = new File(directory);
        if (file.isDirectory()) {
            return file.list();
        }
        return null;
    }
}

