/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class IrProperties {
    private static final String MERLIN = "1.4";
    private static final String IR_DEBUG = "ir.debug";
    private static final String UTF_8 = "UTF-8";
    private static final String DEFAULT_ENCODING = "UTF-8";
    static String IR_HOME = null;
    static String HOME_ENV = "IR_HOME";
    public static boolean USE_DB = true;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_HP;
    public static final boolean IS_AIX;
    private static boolean BROKER;
    private static boolean isAdmin;
    private static boolean brokerSet;
    private static boolean standalone;
    private static boolean isServer;
    private static String serverName;
    public static final String ENCODING;
    public static final String IANA_ENCODING;
    private static final Set DEBUG_KEYS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        BROKER = false;
        isAdmin = false;
        brokerSet = false;
        standalone = false;
        isServer = false;
        serverName = "adminServer";
        IS_WINDOWS = IrProperties.isWindows();
        IS_HP = IrProperties.isHp();
        IS_AIX = IrProperties.isAix();
        ENCODING = IrProperties.determineEncoding();
        IANA_ENCODING = Charset.forName(IrProperties.determineEncoding(true)).name();
        DEBUG_KEYS = new HashSet();
        String property = System.getProperty(IR_DEBUG);
        if (property != null) {
            StringTokenizer tokenizer = new StringTokenizer(property, ",");
            while (tokenizer.hasMoreTokens()) {
                String key = tokenizer.nextToken();
                if (key.length() == 0) continue;
                DEBUG_KEYS.add(key);
            }
        }
    }

    public static boolean isBroker() {
        return BROKER;
    }

    public static void setBroker(boolean broker) {
        if (brokerSet) {
            return;
        }
        brokerSet = true;
        BROKER = broker;
    }

    public static synchronized void fill(String marinerHome) {
        IR_HOME = marinerHome;
    }

    public static synchronized void setHomeEnv(String homeEnv) {
        HOME_ENV = homeEnv;
    }

    public static String getHomeEnv() {
        return HOME_ENV;
    }

    public static synchronized String getHome() {
        if (IR_HOME == null) {
            String propHome = System.getProperty(HOME_ENV);
            if (propHome != null && propHome.trim().length() != 0) {
                IR_HOME = propHome;
            } else {
                if (MERLIN.equals(System.getProperty("java.specification.version"))) {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV);
                }
                Object envHome = null;
                try {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("java.lang.System");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Class[] classArray = new Class[1];
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    classArray[0] = clazz2;
                    Method method = clazz.getMethod("getenv", classArray);
                    envHome = method.invoke(null, HOME_ENV);
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV, e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV, e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV, e);
                }
                catch (SecurityException e) {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV, e);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV, e);
                }
                if (envHome != null && envHome instanceof String) {
                    IR_HOME = (String)envHome;
                } else {
                    throw new RuntimeException("Cannot read property : " + HOME_ENV);
                }
            }
        }
        return IR_HOME;
    }

    public static String getDBWatcherExtensionHome() {
        return String.valueOf(IrProperties.getHome()) + "/lib/dbwatcher";
    }

    public static String getSettingRepository() {
        return new File(String.valueOf(IrProperties.getServerRepository()) + "/setting").getAbsolutePath();
    }

    public static String getAdminServerRepository() {
        return IrProperties.getServerRepository();
    }

    public static String getServerRepository() {
        return new File(String.valueOf(IrProperties.getHome()) + File.separatorChar + "servers" + File.separatorChar + serverName).getAbsolutePath();
    }

    public static String getCollectionRepository(String collectionID) {
        return new File(new File(String.valueOf(IrProperties.getServerRepository()) + File.separatorChar + "collections"), collectionID).getAbsolutePath();
    }

    public static String getCollectionSettingRepository(String collectionID) {
        return new File(String.valueOf(IrProperties.getSettingRepository()) + File.separatorChar + collectionID).getAbsolutePath();
    }

    public static String getDBWatcherSettingRepository(String collectionID) {
        return new File(String.valueOf(IrProperties.getCollectionSettingRepository(collectionID)) + File.separatorChar + "dbwatcher").getAbsolutePath();
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("windows");
    }

    public static boolean isHp() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("hp");
    }

    public static boolean isAix() {
        String os = System.getProperty("os.name");
        return os.toLowerCase().startsWith("aix");
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static void setStandalone(boolean standalone) {
        IrProperties.standalone = standalone;
    }

    private static String determineEncoding(boolean checkIanaRegistered) {
        String fileEncoding = System.getProperty("file.encoding");
        if (fileEncoding != null && IrProperties.availableEncoding(fileEncoding, checkIanaRegistered)) {
            return fileEncoding;
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter(new ByteArrayOutputStream());
            String defaultEncoding = writer.getEncoding();
            if (IrProperties.availableEncoding(defaultEncoding, checkIanaRegistered)) {
                String string = defaultEncoding;
                return string;
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (IrProperties.availableEncoding("UTF-8", checkIanaRegistered)) {
            return "UTF-8";
        }
        throw new RuntimeException("UTF-8 cannot be used anymore.");
    }

    private static String determineEncoding() {
        return IrProperties.determineEncoding(false);
    }

    private static boolean availableEncoding(String fileEncoding, boolean checkIanaRegistered) {
        if (fileEncoding == null || fileEncoding.length() == 0) {
            return false;
        }
        boolean supported = Charset.isSupported(fileEncoding);
        Charset charset = null;
        try {
            charset = Charset.forName(fileEncoding);
        }
        catch (UnsupportedCharsetException e) {
            return false;
        }
        boolean canEncode = charset.canEncode();
        boolean registered = charset.isRegistered();
        return supported && canEncode && (!checkIanaRegistered || registered);
    }

    public static boolean isDebug(String debugKey) {
        StringTokenizer tokenizer = new StringTokenizer(debugKey, ".");
        StringBuffer accumulated = new StringBuffer();
        while (tokenizer.hasMoreTokens()) {
            accumulated.append(tokenizer.nextToken());
            if (DEBUG_KEYS.contains(accumulated.toString())) {
                return true;
            }
            accumulated.append('.');
        }
        return false;
    }

    public static boolean isAdmin() {
        return isAdmin;
    }

    public static void setAdmin() {
        isAdmin = true;
    }

    public static boolean isServerMode() {
        return isServer;
    }

    public static void setServerMode() {
        isServer = true;
    }

    public static void setServerName(String serverName) {
        IrProperties.serverName = serverName;
    }
}

