/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetworkUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSameAddress(String source, String dest) {
        String loopbackIP = "127.0.0.1";
        if (source == null) return false;
        if (dest == null) {
            return false;
        }
        try {
            source = InetAddress.getByName(source).getHostAddress();
            dest = InetAddress.getByName(dest).getHostAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
        if (source.equals(dest)) {
            return true;
        }
        if (!source.equals(loopbackIP)) {
            if (!dest.equals(loopbackIP)) return false;
        }
        String noneLoopbackIP = source;
        if (source.equals(loopbackIP)) {
            noneLoopbackIP = dest;
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            block4: while (true) {
                InetAddress inetAddress;
                if (!interfaces.hasMoreElements()) {
                    return false;
                }
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                do {
                    if (!addresses.hasMoreElements()) continue block4;
                } while (!(inetAddress = addresses.nextElement()).getHostAddress().equals(noneLoopbackIP));
                break;
            }
            return true;
        }
        catch (SocketException e) {
            return false;
        }
    }
}

