/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

public class NumberUtil {
    public static boolean isDigit(char c, int radix) {
        if (2 <= radix && radix <= 36) {
            if (radix <= 10) {
                return '0' <= c && c < radix + 48;
            }
            if (c <= '9') {
                return '0' <= c && c < radix + 48;
            }
            return 'A' <= c && c < radix - 10 + 65 || 'a' <= c && c < radix - 10 + 97;
        }
        return false;
    }

    public static int parseInt(char[] number, int offset, int length, int radix) throws NumberFormatException {
        int result = 0;
        boolean negative = false;
        int i = offset;
        int max = offset + length;
        if (max > 0) {
            int digit;
            int limit;
            if (number[offset] == '-') {
                negative = true;
                limit = Integer.MIN_VALUE;
                ++i;
            } else {
                limit = -2147483647;
            }
            int multmin = limit / radix;
            if (i < max) {
                if ((digit = Character.digit(number[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(number, offset, length) + "\"");
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(number[i++], radix)) < 0) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(number, offset, length) + "\"");
                }
                if (result < multmin) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(number, offset, length) + "\"");
                }
                if ((result *= radix) < limit + digit) {
                    throw new NumberFormatException("For input string: \"" + String.valueOf(number, offset, length) + "\"");
                }
                result -= digit;
            }
        } else {
            throw new NumberFormatException("For input string: \"" + String.valueOf(number, offset, length) + "\"");
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException("For input string: \"" + String.valueOf(number, offset, length) + "\"");
        }
        return -result;
    }

    public static String getOrdinalSuffix(int number) {
        int positive = number < 0 ? -number : number;
        String suffix = "th";
        int lastDigit = positive % 10;
        int tenThDigit = positive % 100 / 10;
        if (lastDigit <= 3 && lastDigit >= 1 && tenThDigit != 1) {
            if (lastDigit == 1) {
                suffix = "st";
            } else if (lastDigit == 2) {
                suffix = "nd";
            } else if (lastDigit == 3) {
                suffix = "rd";
            }
        }
        return suffix;
    }

    public static void main(String[] args) {
        int r = 2;
        while (r <= 36) {
            System.out.println("0 " + r + "\t" + NumberUtil.isDigit('0', r));
            System.out.println("3 " + r + "\t" + NumberUtil.isDigit('3', r));
            System.out.println("9 " + r + "\t" + NumberUtil.isDigit('9', r));
            System.out.println("a " + r + "\t" + NumberUtil.isDigit('a', r));
            System.out.println("A " + r + "\t" + NumberUtil.isDigit('A', r));
            System.out.println("f " + r + "\t" + NumberUtil.isDigit('f', r));
            System.out.println("F " + r + "\t" + NumberUtil.isDigit('F', r));
            System.out.println("Z " + r + "\t" + NumberUtil.isDigit('Z', r));
            System.out.println("z " + r + "\t" + NumberUtil.isDigit('z', r));
            System.out.println("* " + r + "\t" + NumberUtil.isDigit('*', r));
            ++r;
        }
    }
}

