/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class PageNavigator {
    public static final int PAGE_SIZE = 10;
    public static final int GROUP_SCALE = 10;
    public int pageSize = 10;
    public int groupScale = 10;
    public int totalRowCount_ = 0;
    public int currentPage_;
    public final String pageName_;
    private String param_ = "";
    private String encoding = "UTF-8";
    private String[] paramName;
    private String[] paramValue;
    private String path_;
    private String preImgPath;
    private String nextImgPath;
    private String firstImgPath;
    private String lastImgPath;

    public PageNavigator(int currentPage, String pageName) {
        this(currentPage, pageName, 10, 10);
    }

    public PageNavigator(int currentPage, String pageName, int pageSize) {
        this(currentPage, pageName, pageSize, 10);
    }

    public PageNavigator(int currentPage, String pageName, int pageSize, int groupScale) {
        this.currentPage_ = currentPage;
        this.pageName_ = pageName;
        this.pageSize = pageSize;
        this.groupScale = groupScale;
    }

    public PageNavigator(int totalRowCount, int currentPage, String pageName) {
        this(totalRowCount, currentPage, pageName, "");
    }

    public PageNavigator(int totalRowCount, int currentPage, String pageName, String path) {
        this.totalRowCount_ = totalRowCount;
        this.setCurrentPage(currentPage);
        this.pageName_ = pageName;
        this.path_ = path;
    }

    public void setNavigationImage(String pre, String next) {
        this.preImgPath = pre;
        this.nextImgPath = next;
    }

    public void setNavigationImage(String path, String pre, String next, String first, String last) {
        this.path_ = path;
        this.preImgPath = pre;
        this.nextImgPath = next;
        this.firstImgPath = first;
        this.lastImgPath = last;
    }

    public void setTotalCount(int totalCount) {
        this.totalRowCount_ = totalCount;
    }

    private void setCurrentPage(int currentPage) {
        this.currentPage_ = currentPage > this.getTotalPageCount() && this.getTotalPageCount() != 0 ? this.getTotalPageCount() : currentPage;
    }

    public int getTotalPageCount() {
        if (this.totalRowCount_ % this.pageSize == 0) {
            return this.totalRowCount_ / this.pageSize;
        }
        return this.totalRowCount_ / this.pageSize + 1;
    }

    public int getStartRowNumber() {
        return (this.currentPage_ - 1) * this.pageSize + 1;
    }

    public int getEndRowNumber() {
        int endRowNumber = this.getStartRowNumber() + this.pageSize - 1;
        if (this.totalRowCount_ != 0 && endRowNumber > this.totalRowCount_) {
            return this.totalRowCount_;
        }
        return endRowNumber;
    }

    public int getPageGroupStart() {
        return (this.getPageGroup() - 1) * this.groupScale + 1;
    }

    public int getPageGroup() {
        return (this.currentPage_ - 1) / this.groupScale + 1;
    }

    public int getPageGroupCount() {
        return (this.getTotalPageCount() - 1) / this.groupScale + 1;
    }

    public int getPageGroupEnd() {
        int pageGroupEnd = this.getPageGroupStart() + this.groupScale - 1;
        if (pageGroupEnd > this.getTotalPageCount()) {
            return this.getTotalPageCount();
        }
        return pageGroupEnd;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String setParams(String[] namePairs, String[] valuePairs, String encoding) throws UnsupportedEncodingException {
        String result = "";
        int i = 0;
        while (i < namePairs.length) {
            result = String.valueOf(result) + "&" + namePairs[i] + "=" + URLEncoder.encode(valuePairs[i], encoding);
            ++i;
        }
        this.param_ = result;
        return this.param_;
    }

    public String setParams(String[] namePairs, String[] valuePairs) throws UnsupportedEncodingException {
        this.paramName = namePairs;
        this.paramValue = valuePairs;
        return this.setParams(namePairs, valuePairs, this.encoding);
    }

    public void setParam(String key, String value, String encoding) throws UnsupportedEncodingException {
        this.param_ = String.valueOf(this.param_) + "&" + key + "=" + URLEncoder.encode(value, encoding);
    }

    public void setParam(String key, String value) throws UnsupportedEncodingException {
        this.setParam(key, value, this.encoding);
    }

    public String toPostString() {
        String navBar = "";
        if (this.getTotalPageCount() == 0) {
            return "";
        }
        navBar = String.valueOf(navBar) + "<script>function fnNavigate(param){document.pageNavigator.currentPage.value=param;document.pageNavigator.submit();}</script>";
        navBar = String.valueOf(navBar) + "<form name='pageNavigator' method='POST' action='" + this.pageName_ + "'>";
        navBar = String.valueOf(navBar) + "<input type='hidden' name='currentPage'>";
        int i = 0;
        while (i < this.paramName.length) {
            navBar = String.valueOf(navBar) + "<input type='hidden' name='" + this.paramName[i] + "' value='" + this.paramValue[i] + "'>";
            ++i;
        }
        navBar = String.valueOf(navBar) + "<table width=\"720\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\"><tr><td width=\"279\"><div align=\"right\">";
        navBar = 1 == this.getPageGroupStart() ? String.valueOf(navBar) + "<img src=\"" + this.path_ + this.preImgPath + "\" width=\"17\" border=\"0\" height=\"17\">" : String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + (this.getPageGroupStart() - 1) + ") \"><img src=\"" + this.path_ + this.preImgPath + "\" border=\"0\" width=\"17\" height=\"17\"></a>";
        navBar = String.valueOf(navBar) + "</div></td><td width=\"170\"><div align=\"center\" class=\"unnamed15\">";
        i = this.getPageGroupStart();
        while (i <= this.getPageGroupEnd()) {
            if (i == this.currentPage_) {
                navBar = String.valueOf(navBar) + "<strong><span class=\"unnamed14\"><a href=\"javascript:fnNavigate(" + i + ") \">" + i + "</a></span></strong> ";
                if (i == this.getPageGroupEnd()) {
                    navBar = String.valueOf(navBar) + " ";
                }
            } else {
                navBar = String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + i + ") \">" + i + "</a> ";
            }
            ++i;
        }
        navBar = String.valueOf(navBar) + "</div></td><td width=\"251\">";
        navBar = this.getTotalPageCount() == this.getPageGroupEnd() ? String.valueOf(navBar) + "<img src=\"" + this.path_ + this.nextImgPath + "\" border=\"0\" width=\"17\" height=\"17\">" : String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + (this.getPageGroupEnd() + 1) + ") \"><img src=\"" + this.path_ + this.nextImgPath + "\" border=\"0\" width=\"17\" height=\"17\"></a>";
        navBar = String.valueOf(navBar) + "</td></tr></table>";
        return navBar;
    }

    public String toPostNOFormString() {
        String navBar = "";
        if (this.getTotalPageCount() == 0) {
            return "";
        }
        navBar = String.valueOf(navBar) + "<script>function fnNavigate(param){document.pageNavigator.currentPage.value=param;document.pageNavigator.submit();}</script>";
        navBar = String.valueOf(navBar) + "<table width=100% border=\"0\" cellspacing=\"2\" cellpadding=\"2\"><tr height=\"30\" align=center valign=middle><td align=center><div>";
        if (1 != this.getPageGroupStart()) {
            navBar = String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(1) \"><img src=\"" + this.path_ + this.firstImgPath + "\" border=\"0\"></a>";
            navBar = String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + (this.getPageGroupStart() - 1) + ") \"><img src=\"" + this.path_ + this.preImgPath + "\" border=\"0\"></a>&nbsp;&nbsp;";
        }
        int i = this.getPageGroupStart();
        while (i <= this.getPageGroupEnd()) {
            if (i == this.currentPage_) {
                navBar = String.valueOf(navBar) + "<strong><span><a href=\"javascript:fnNavigate(" + i + ") \">" + i + "</a>&nbsp;&nbsp;</span></strong>";
                if (i == this.getPageGroupEnd()) {
                    navBar = String.valueOf(navBar) + " ";
                }
            } else {
                navBar = String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + i + ") \">" + i + "</a>&nbsp;&nbsp;";
            }
            ++i;
        }
        if (this.getTotalPageCount() != this.getPageGroupEnd()) {
            navBar = String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + (this.getPageGroupEnd() + 1) + ") \"><img src=\"" + this.path_ + this.nextImgPath + "\" border=\"0\" ></a>";
            navBar = String.valueOf(navBar) + "<a href=\"javascript:fnNavigate(" + this.getTotalPageCount() + ") \"><img src=\"" + this.path_ + this.lastImgPath + "\" border=\"0\"></a>";
        }
        navBar = String.valueOf(navBar) + "</td></tr></table>";
        return navBar;
    }

    public String toString() {
        String navBar = "";
        if (this.getTotalPageCount() == 0) {
            return "";
        }
        navBar = "<table width=\"720\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\"><tr><td width=\"279\"><div align=\"right\">";
        navBar = 1 == this.getPageGroupStart() ? String.valueOf(navBar) + "<img src=\"" + this.path_ + "image/pre.gif\" width=\"17\" border=\"0\" height=\"17\">" : String.valueOf(navBar) + "<a href=\"" + this.pageName_ + "?currentPage=" + (this.getPageGroupStart() - 1) + this.param_ + "\"><img src=\"" + this.path_ + "image/pre.gif\" border=\"0\" width=\"17\" height=\"17\"></a>";
        navBar = String.valueOf(navBar) + "</div></td><td width=\"170\"><div align=\"center\" class=\"unnamed15\">";
        int i = this.getPageGroupStart();
        while (i <= this.getPageGroupEnd()) {
            if (i == this.currentPage_) {
                navBar = String.valueOf(navBar) + "<strong><span class=\"unnamed14\"><a href=\"" + this.pageName_ + "?currentPage=" + i + this.param_ + "\">" + i + "</a></span></strong> ";
                if (i == this.getPageGroupEnd()) {
                    navBar = String.valueOf(navBar) + " ";
                }
            } else {
                navBar = String.valueOf(navBar) + "<a href=\"" + this.pageName_ + "?currentPage=" + i + this.param_ + "\">" + i + "</a> ";
            }
            ++i;
        }
        navBar = String.valueOf(navBar) + "</div></td><td width=\"251\">";
        navBar = this.getTotalPageCount() == this.getPageGroupEnd() ? String.valueOf(navBar) + "<img src=\"" + this.path_ + "image/next.gif\" border=\"0\" width=\"17\" height=\"17\">" : String.valueOf(navBar) + "<a href=\"" + this.pageName_ + "?currentPage=" + (this.getPageGroupEnd() + 1) + this.param_ + "\"><img src=\"" + this.path_ + "image/next.gif\" border=\"0\" width=\"17\" height=\"17\"></a>";
        navBar = String.valueOf(navBar) + "</td></tr></table>";
        return navBar;
    }

    public String textNavigation() {
        String navBar = "";
        if (this.getTotalPageCount() == 0) {
            return "";
        }
        navBar = "<table width=\"720\" border=\"0\" cellspacing=\"2\" cellpadding=\"2\"><tr><td width=\"279\"><div align=\"right\">";
        navBar = 1 == this.getPageGroupStart() ? String.valueOf(navBar) + "<b><</b>" : String.valueOf(navBar) + "<a href=\"" + this.pageName_ + "?currentPage=" + (this.getPageGroupStart() - 1) + this.param_ + "\"><b><</b></a>";
        navBar = String.valueOf(navBar) + "</div></td><td width=\"170\"><div align=\"center\" class=\"unnamed15\">";
        int i = this.getPageGroupStart();
        while (i <= this.getPageGroupEnd()) {
            if (i == this.currentPage_) {
                navBar = String.valueOf(navBar) + "<strong><span class=\"unnamed14\"><a href=\"" + this.pageName_ + "?currentPage=" + i + this.param_ + "\">" + i + "</a></span></strong> ";
                if (i == this.getPageGroupEnd()) {
                    navBar = String.valueOf(navBar) + " ";
                }
            } else {
                navBar = String.valueOf(navBar) + "<a href=\"" + this.pageName_ + "?currentPage=" + i + this.param_ + "\">" + i + "</a> ";
            }
            ++i;
        }
        navBar = String.valueOf(navBar) + "</div></td><td width=\"251\">";
        navBar = this.getTotalPageCount() == this.getPageGroupEnd() ? String.valueOf(navBar) + "<b>></b>" : String.valueOf(navBar) + "<a href=\"" + this.pageName_ + "?currentPage=" + (this.getPageGroupEnd() + 1) + this.param_ + "\"><b>></b></a>";
        navBar = String.valueOf(navBar) + "</td></tr></table>";
        return navBar;
    }

    public static void main(String[] args) {
        PageNavigator page = new PageNavigator(657, 3, "b.jsp", "/home/dk/");
        System.out.println(page.toString());
        System.out.println(page.toPostNOFormString());
        try {
            page.setParams(new String[]{"a", "b", "c"}, new String[]{"1", "2", "3"});
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        System.out.println(page.toPostString());
    }
}

