/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

public class PrimitiveCache {
    public static Long valueOf(long l) {
        int offset = 128;
        if (l >= -128L && l <= 127L) {
            return LongCache.cache[(int)l + 128];
        }
        return new Long(l);
    }

    public static Integer valueOf(int i) {
        int offset = 128;
        if (i >= -128 && i <= 127) {
            return IntegerCache.cache[i + 128];
        }
        return new Integer(i);
    }

    public static Character valueOf(char c) {
        if (c <= '\u007f') {
            return CharacterCache.cache[c];
        }
        return new Character(c);
    }

    static class CharacterCache {
        static final Character[] cache = new Character[128];

        static {
            int i = 0;
            while (i < cache.length) {
                CharacterCache.cache[i] = new Character((char)i);
                ++i;
            }
        }

        private CharacterCache() {
        }
    }

    static class IntegerCache {
        final int offset = 128;
        static final Integer[] cache = new Integer[256];

        static {
            int i = 0;
            while (i < cache.length) {
                IntegerCache.cache[i] = new Integer(i - 128);
                ++i;
            }
        }
    }

    static class LongCache {
        static final Long[] cache = new Long[256];

        static {
            int i = 0;
            while (i < cache.length) {
                LongCache.cache[i] = new Long(i - 128);
                ++i;
            }
        }

        private LongCache() {
        }
    }
}

