/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import com.diquest.ir.util.common.PrimitiveCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SmartMatcher {
    public static int match(String from, String[] to) {
        return SmartMatcher.match(new String[]{from}, to)[0];
    }

    public static int[] match(String[] from, String[] to) {
        int UNDEFINED = -1;
        int[] direction = new int[from.length];
        Arrays.fill(direction, -1);
        HashSet fromSet = new HashSet(from.length, 1.0f);
        HashMap toMap = new HashMap(to.length, 1.0f);
        Set toSet = toMap.keySet();
        SmartMatcher.addAll(fromSet, from);
        SmartMatcher.putAll(toMap, to);
        int i = 0;
        while (i < from.length) {
            if (toSet.contains(from[i])) {
                Integer index = (Integer)toMap.get(from[i]);
                direction[i] = index;
            }
            ++i;
        }
        i = 0;
        while (i < from.length) {
            if (direction[i] == -1) {
                double max = -1.0;
                int maxIdx = -1;
                int j = 0;
                while (j < to.length) {
                    double matchScore = SmartMatcher.getMatchScore(from[i], to[j]);
                    if (max < matchScore) {
                        maxIdx = j;
                        max = matchScore;
                    }
                    ++j;
                }
                direction[i] = maxIdx;
            }
            ++i;
        }
        return direction;
    }

    private static void addAll(Collection col, String[] list) {
        int i = 0;
        while (i < list.length) {
            col.add(list[i]);
            ++i;
        }
    }

    private static void putAll(Map map, String[] list) {
        int i = 0;
        while (i < list.length) {
            map.put(list[i], PrimitiveCache.valueOf(i));
            ++i;
        }
    }

    private static double getMatchScore(String src, String dst) {
        char[] srcArr = src.toCharArray();
        char[] dstArr = dst.toCharArray();
        int lcs = SmartMatcher.getLcsScore(srcArr, dstArr);
        int prefix = SmartMatcher.getPrefixScore(srcArr, dstArr);
        int suffix = SmartMatcher.getSuffixScore(srcArr, dstArr);
        return (double)(prefix + suffix + lcs) / (double)dst.length();
    }

    public static int getSuffixScore(char[] src, char[] dst) {
        int suffix = 0;
        int s = src.length;
        int d = dst.length;
        while (s > 0 && d > 0) {
            if (src[--s] != dst[--d]) continue;
            ++suffix;
        }
        return suffix;
    }

    public static int getPrefixScore(char[] src, char[] dst) {
        int prefix = 0;
        int i = 0;
        while (i < src.length && i < dst.length) {
            if (src[i] != dst[i]) break;
            ++prefix;
            ++i;
        }
        return prefix;
    }

    public static int getLcsScore(char[] src, char[] dst) {
        int[][] score = new int[2][dst.length + 1];
        boolean flag = true;
        int s = 1;
        while (s <= src.length) {
            flag = !flag;
            int current = flag ? 1 : 0;
            int previous = flag ? 0 : 1;
            int d = 1;
            while (d <= dst.length) {
                int same = src[s - 1] == dst[d - 1] ? 1 : 0;
                score[current][d] = SmartMatcher.max(score[previous][d - 1] + same, score[previous][d], score[current][d - 1]);
                ++d;
            }
            ++s;
        }
        return score[flag ? 1 : 0][dst.length];
    }

    public static int max(int a, int b, int c) {
        return a > b ? (a > c ? a : c) : (b > c ? b : c);
    }

    public static void main(String[] args) {
        double matchScore = SmartMatcher.getMatchScore("prAefixteAst", "pAreftest");
        System.out.println(matchScore);
        String[] a = new String[]{"asjhdak", "edfjsjkl", "aerfnakne", "3rwei", "wtnsf", "mekflsfkm", "wtlnedslgk", "mefn;sone", "shrhgnos4"};
        String[] b = new String[]{"aeajhdak", "4ltjwtnsf", "eiougshrhgno4", "e5edfsjkl", "mkflsfko9shm", "wtlnedslgk", "mefnodsne", "erf4efnakne", "3rwei"};
        int[] is = SmartMatcher.match(a, b);
        int i = 0;
        while (i < is.length) {
            System.out.println(String.valueOf(a[i]) + "\t" + b[is[i]]);
            ++i;
        }
    }
}

