/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

import com.diquest.ir.util.common.CharUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StringUtil {
    public static final String[] NULL_FORMAT;
    private String value_;

    static {
        String[] stringArray = new String[2];
        stringArray[1] = "";
        NULL_FORMAT = stringArray;
    }

    public StringUtil(String value) {
        this.value_ = value != null ? value : "";
    }

    public static void print(Object[] source) {
        String result = "[";
        int i = 0;
        while (i < source.length) {
            result = String.valueOf(result) + source[i];
            if (i != source.length - 1) {
                result = String.valueOf(result) + ",";
            }
            ++i;
        }
        result = String.valueOf(result) + "]";
    }

    public StringUtil(int value) {
        this.value_ = String.valueOf(value);
    }

    public StringUtil(String value, String defaultValue) {
        this.value_ = value != null ? value : defaultValue;
    }

    public void padding(int length, char padding) {
        while (this.value_.length() < length) {
            this.value_ = String.valueOf(this.value_) + padding;
        }
    }

    public void leftPadding(int length, char padding) {
        while (this.value_.length() < length) {
            this.value_ = String.valueOf(padding) + this.value_;
        }
    }

    public static String format(char[][] source, char iter) {
        StringBuffer trans = new StringBuffer();
        int i = 0;
        while (i < source.length) {
            trans.append(source[i]);
            if (i != source.length - 1) {
                trans.append(iter);
            }
            ++i;
        }
        return trans.toString();
    }

    public static List split(String source, String iter) {
        ArrayList<String> list = new ArrayList<String>();
        String[] result = source.split(iter);
        int i = 0;
        while (i < result.length) {
            if (!result[i].equals("")) {
                list.add(result[i].trim());
            }
            ++i;
        }
        return list;
    }

    public static String format(String[] source, char iter) {
        if (source == null) {
            return "";
        }
        StringBuffer trans = new StringBuffer();
        int i = 0;
        while (i < source.length) {
            trans.append(source[i]);
            if (i != source.length - 1) {
                trans.append(iter);
            }
            ++i;
        }
        return trans.toString();
    }

    public static String format(String[] source, String iter) {
        if (source == null) {
            return "";
        }
        StringBuffer trans = new StringBuffer();
        int i = 0;
        while (i < source.length) {
            trans.append(source[i]);
            if (i != source.length - 1) {
                trans.append(iter);
            }
            ++i;
        }
        return trans.toString();
    }

    public static String format(Collection source, char iter) {
        return StringUtil.format(source, String.valueOf(iter));
    }

    public static String format(Collection source, String iter) {
        if (source == null) {
            return "";
        }
        StringBuffer trans = new StringBuffer();
        int sourceSize = source.size();
        Iterator iterator = source.iterator();
        while (--sourceSize > 0) {
            trans.append(iterator.next());
            trans.append(iter);
        }
        if (!source.isEmpty()) {
            trans.append(iterator.next());
        }
        return trans.toString();
    }

    public static String[] rolling(String source, int count) {
        String[] rolled = new String[count];
        int i = 0;
        while (i < count) {
            rolled[i] = new String(source);
            ++i;
        }
        return rolled;
    }

    public static String patternReplace(String source, String pattern, String replace) {
        return source.replaceAll(pattern, replace);
    }

    public static String phaseReplace(String source, String[] match, String replace) {
        int i = 0;
        while (i < match.length) {
            if (source == match[i]) {
                return replace;
            }
            if (source.equals(match[i])) {
                return replace;
            }
            ++i;
        }
        return source;
    }

    public static String cut(String origin, int max) {
        if (origin.length() > max) {
            origin = origin.substring(0, max);
        }
        return origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        StringUtil castedObj = (StringUtil)o;
        return this.value_ == null ? castedObj.value_ == null : this.value_.equals(castedObj.value_);
    }

    public String toString() {
        return this.value_;
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.getFormattedKeywords("BB,AA^1,DD,c^22,E, ", '^', ','));
        System.out.println("Expected:\nBB,AA,DD,c,E, ");
        System.out.println(StringUtil.getFormattedKeywords("BB,AA^1,DD,c^22,E", '^', ','));
        System.out.println("Expected:\nBB,AA,DD,c,E");
        System.out.println(StringUtil.getFormattedKeywords("BB,AA^1,DD,c^22,E, ", '^', ','));
        System.out.println("Expected:\nBB,AA,DD,c,E, ");
        System.out.println(StringUtil.getFormattedKeywords("AA", '^', ','));
        System.out.println("Expected:\nAA");
        System.out.println(StringUtil.getFormattedKeywords("AA^1", '^', ','));
        System.out.println("Expected:\nAA");
        System.out.println(StringUtil.getFormattedKeywords("AA^1,BB", '^', ','));
        System.out.println("Expected:\nAA,BB");
        System.out.println(StringUtil.getFormattedKeywords("BB,AA^1", '^', ','));
        System.out.println("Expected:\nBB,AA");
        System.out.println(StringUtil.getFormattedKeywords("BB^11,AA^11", '^', ','));
        System.out.println("Expected:\nBB,AA");
        System.out.println(StringUtil.getFormattedKeywords("BB^,", '^', ','));
        System.out.println("Expected:\nBB,");
        System.out.println(StringUtil.getFormattedKeywords("BB^", '^', ','));
        System.out.println("Expected:\nBB");
        System.out.println(StringUtil.getFormattedKeywords("AA^11,BB,CC^22,AA^11,BB,CC^22,AA^11,BB,CC^22,DD", '^', ','));
        System.out.println("Expected:\nAA,BB,CC,AA,BB,CC,AA,BB,CC,DD");
        String str = "asdf&|zxcv&qwer|gggg&|vbmn&";
        int from = 0;
        int newFrom = 0;
        while (newFrom != -1) {
            newFrom = str.indexOf("&|", from);
            System.out.println(String.valueOf(newFrom));
            if (newFrom != -1) {
                System.out.println(str.substring(from, newFrom));
                from = newFrom + 2;
                continue;
            }
            System.out.println(str.substring(from, str.length()));
        }
    }

    public static String lpadding(String pad, String source, int minimum) {
        int padding = minimum - source.length();
        if (padding > 0) {
            int i = 0;
            while (i < padding) {
                source = String.valueOf(pad) + source;
                ++i;
            }
        }
        return source;
    }

    public static String intoString(String str) {
        if (str == null) {
            return "";
        }
        char[] charArr = str.toCharArray();
        int len = charArr.length;
        StringBuffer strB = new StringBuffer();
        int i = 0;
        while (i < len) {
            switch (charArr[i]) {
                case '\"': 
                case '\'': 
                case '\\': {
                    strB = strB.append("\\" + charArr[i]);
                    break;
                }
                default: {
                    strB = strB.append(charArr[i]);
                }
            }
            ++i;
        }
        return strB.toString();
    }

    public static String simpleHTML2Text(String str) {
        if (str == null) {
            return "";
        }
        char[] charArr = str.toCharArray();
        int len = charArr.length;
        StringBuffer strB = new StringBuffer();
        int i = 0;
        while (i < len) {
            switch (charArr[i]) {
                case '<': {
                    strB = strB.append("&lt;");
                    break;
                }
                case '>': {
                    strB = strB.append("&gt;");
                    break;
                }
                case '&': {
                    strB = strB.append("&amp;");
                    break;
                }
                case '\"': {
                    strB = strB.append("&quot;");
                    break;
                }
                default: {
                    strB = strB.append(charArr[i]);
                }
            }
            ++i;
        }
        return strB.toString();
    }

    public static String simpleHTML2TextQuot(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\"", "&quot;");
    }

    public static String simpleHTML2TextBSlashQuot(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "&quot;");
    }

    public static String simpleHTML2TextBSlashQuotApos(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "&quot;").replaceAll("'", "\\\\&#39;");
    }

    public static String simpleText2HTML(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&quot;", "\"");
    }

    public static String simpleHTML2TextApos(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("'", "\\\\&#39;");
    }

    public static String simpleText2HTMLApos(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\\\\&#39;", "'");
    }

    public static String simpleHTML2TextAmp(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&", "&amp;");
    }

    public static String simpleText2HTMLAmp(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("&amp;", "&");
    }

    public static String toSimpleRegex(String str) {
        StringBuffer buf = new StringBuffer((int)((double)str.length() * 1.1));
        char[] cs = str.toCharArray();
        int i = 0;
        while (i < cs.length) {
            switch (cs[i]) {
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '|': {
                    buf.append('\\').append(cs[i]);
                    break;
                }
                default: {
                    buf.append(cs[i]);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String encodeFromTo(String src, String srcEnc, String dstEnc) throws UnsupportedEncodingException {
        if (src == null || srcEnc == null || dstEnc == null) {
            throw new NullPointerException("String to change is null or given encoding names are null.");
        }
        byte[] bytes = src.getBytes(srcEnc);
        return new String(bytes, dstEnc);
    }

    public static String encodeTo(String src, String dstEnc) {
        if (src == null || dstEnc == null) {
            return src;
        }
        try {
            byte[] bytes = src.getBytes("UTF-16BE");
            return new String(bytes, dstEnc);
        }
        catch (UnsupportedEncodingException e) {
            return src;
        }
    }

    public static String decodeFrom(String src, String srcEnc) {
        if (src == null || srcEnc == null) {
            return src;
        }
        try {
            byte[] bytes = src.getBytes(srcEnc);
            return new String(bytes, "UTF-16BE");
        }
        catch (UnsupportedEncodingException e) {
            return src;
        }
    }

    public static String compactWhitespace(String string) {
        return new String(CharUtil.compactWhitespace(string.toCharArray()));
    }

    public static String removeWhitespaces(String string) {
        return new String(CharUtil.removeWhitespace(string.toCharArray()));
    }

    public static String replace(String source, String changee, char c) {
        return new String(CharUtil.replace(source.toCharArray(), changee.toCharArray(), c));
    }

    public static char[][] convert(String[] array) {
        char[][] converted = new char[array.length][];
        int i = 0;
        while (i < array.length) {
            converted[i] = array[i].toCharArray();
            ++i;
        }
        return converted;
    }

    public static String[] convert(char[][] array) {
        String[] converted = new String[array.length];
        int i = 0;
        while (i < array.length) {
            converted[i] = String.valueOf(array[i]);
            ++i;
        }
        return converted;
    }

    public static String[] convert(Collection collection) {
        String[] converted = new String[collection.size()];
        int i = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            converted[i++] = String.valueOf((char[])iterator.next());
        }
        return converted;
    }

    public static final String replaceWhiteSpaceToSingleSpace(String str) {
        char[] arr = str.toCharArray();
        char[] copied = new char[arr.length];
        int pos = 0;
        boolean prevSpace = false;
        int i = 0;
        while (i < arr.length) {
            if (CharUtil.isSpace(arr[i])) {
                if (!prevSpace) {
                    copied[pos++] = 32;
                }
                prevSpace = true;
            } else {
                copied[pos++] = arr[i];
                prevSpace = false;
            }
            ++i;
        }
        return new String(copied, 0, pos);
    }

    public static final String toString(char[][] stringArray) {
        if (stringArray == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        if (stringArray.length > 0) {
            if (stringArray[0] == null) {
                buf.append("null");
            } else {
                buf.append(stringArray[0]);
            }
        }
        int k = 1;
        while (k < stringArray.length) {
            if (stringArray[k] == null) {
                buf.append(", null");
            } else {
                buf.append(", ").append(stringArray[k]);
            }
            ++k;
        }
        buf.append(']');
        return buf.toString();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String getFormattedKeywords(String keywordSet, char sep, char delim) {
        char[] keywords = keywordSet.toCharArray();
        int start = 0;
        int realLength = 0;
        int keywordLength = keywords.length;
        int pre = 0;
        int next = 0;
        int i = 0;
        while (i < keywordLength) {
            pre = CharUtil.indexOf(keywords, sep, start);
            if (pre > 0) {
                next = CharUtil.indexOf(keywords, delim, start);
                if (next > 0) {
                    realLength = pre > next ? StringUtil.copyArr(keywords, start, realLength, next) : StringUtil.copyArr(keywords, start, realLength, pre);
                    keywords[realLength++] = delim;
                    start = next + 1;
                } else {
                    realLength = StringUtil.copyArr(keywords, start, realLength, pre);
                    i = keywordLength;
                }
            } else {
                realLength = StringUtil.copyArr(keywords, start, realLength, keywordLength);
                i = keywordLength;
            }
            ++i;
        }
        return new String(keywords, 0, realLength);
    }

    private static int copyArr(char[] keywords, int start, int realLength, int next) {
        int j = start;
        while (j < next) {
            keywords[realLength++] = keywords[j];
            ++j;
        }
        return realLength;
    }
}

