/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common;

public class TimeUtil {
    public static final long SEC = 1000L;
    public static final long MIN = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;

    public static final int getDay(long time) {
        return (int)(time / 86400000L);
    }

    public static final int getHour(long time) {
        return (int)(time / 3600000L);
    }

    public static final int getMin(long time) {
        return (int)(time / 60000L);
    }

    public static final int getSec(long time) {
        return (int)(time / 1000L);
    }

    public static final String getTimeStringKOR(long time) {
        StringBuffer buf = new StringBuffer();
        int day = TimeUtil.getDay(time);
        int hour = TimeUtil.getHour(time % 86400000L);
        int min = TimeUtil.getMin(time % 3600000L);
        int sec = TimeUtil.getSec(time % 60000L);
        int millis = (int)(time % 1000L);
        if (day > 0) {
            buf.append(day).append('\uc77c').append(' ');
        }
        if (day > 0 || hour > 0) {
            buf.append(hour).append("\uc2dc\uac04").append(' ');
        }
        if (day > 0 || hour > 0 || min > 0) {
            buf.append(min).append('\ubd84').append(' ');
        }
        if (day > 0 || hour > 0 || min > 0 || sec > 0) {
            buf.append(sec).append('\ucd08').append(' ');
        }
        buf.append(millis).append("ms");
        return buf.toString();
    }

    public static final String getTimeStringEng(long time) {
        StringBuffer buf = new StringBuffer();
        int day = TimeUtil.getDay(time);
        int hour = TimeUtil.getHour(time % 86400000L);
        int min = TimeUtil.getMin(time % 3600000L);
        int sec = TimeUtil.getSec(time % 60000L);
        int millis = (int)(time % 1000L);
        if (day > 0) {
            buf.append(day).append("DAYS").append(' ');
        }
        if (day > 0 || hour > 0) {
            buf.append(hour).append("HOURS").append(' ');
        }
        if (day > 0 || hour > 0 || min > 0) {
            buf.append(min).append("MINUTES").append(' ');
        }
        if (day > 0 || hour > 0 || min > 0 || sec > 0) {
            buf.append(sec).append("SECONDS").append(' ');
        }
        buf.append(millis).append("ms");
        return buf.toString();
    }

    public static final String getTimeString(long time) {
        StringBuffer buf = new StringBuffer();
        int hour = TimeUtil.getHour(time % 86400000L);
        int min = TimeUtil.getMin(time % 3600000L);
        int sec = TimeUtil.getSec(time % 60000L);
        if (hour < 10) {
            buf.append('0');
        }
        buf.append(hour).append(':');
        if (min < 10) {
            buf.append('0');
        }
        buf.append(min).append(':');
        if (sec < 10) {
            buf.append('0');
        }
        buf.append(sec);
        return buf.toString();
    }
}

