/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common.process;

import com.diquest.ir.util.common.process.StreamConsumer;
import com.diquest.ir.util.common.process.StreamConsumerThread;
import java.io.IOException;
import java.io.InputStream;

public class RuntimeExecutor {
    public static int execute(String cmd) throws IOException, InterruptedException {
        int exitValue = 0;
        System.out.println("[Process Command = " + cmd + "]");
        Process ps = Runtime.getRuntime().exec(cmd);
        InputStream inputStream = ps.getInputStream();
        InputStream errorStream = ps.getErrorStream();
        StreamConsumerThread inputStreamConsumer = new StreamConsumerThread(inputStream, "inputStream");
        StreamConsumerThread errorStreamConsumer = new StreamConsumerThread(errorStream, "errorStream");
        inputStreamConsumer.start();
        errorStreamConsumer.start();
        try {
            if (ps.waitFor() != 0) {
                System.out.println("[Runtime Process  = " + cmd + "] exit with " + ps.exitValue());
            }
            exitValue = ps.exitValue();
        }
        finally {
            inputStreamConsumer.join();
            errorStreamConsumer.join();
            ps.destroy();
        }
        return exitValue;
    }

    public static int execute(String cmd, final StreamConsumer outConsumer, final StreamConsumer errConsumer) throws IOException, InterruptedException {
        int exitValue = 0;
        Process ps = Runtime.getRuntime().exec(cmd);
        InputStream inputStream = ps.getInputStream();
        InputStream errorStream = ps.getErrorStream();
        outConsumer.setStream(inputStream);
        errConsumer.setStream(errorStream);
        outConsumer.start();
        errConsumer.start();
        Thread outThread = new Thread("RuntimeExecutor-out: " + cmd){

            public void run() {
                try {
                    outConsumer.startConsume();
                }
                catch (IOException e) {
                    outConsumer.handleIOException(e);
                }
            }
        };
        Thread errThread = new Thread("RuntimeExecutor-err: " + cmd){

            public void run() {
                try {
                    errConsumer.startConsume();
                }
                catch (IOException e) {
                    errConsumer.handleIOException(e);
                }
            }
        };
        outThread.start();
        errThread.start();
        try {
            ps.waitFor();
            exitValue = ps.exitValue();
        }
        finally {
            try {
                outThread.join();
                outConsumer.stop();
            }
            finally {
                try {
                    errThread.join();
                    errConsumer.stop();
                }
                finally {
                    ps.destroy();
                }
            }
        }
        return exitValue;
    }
}

