/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common.vector;

public class ByteVector {
    public byte[] vector;
    public int start;
    public int length;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.common.vector.ByteVector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ByteVector() {
        this.vector = null;
        this.start = -1;
        this.length = -1;
    }

    public ByteVector(byte[] vector, int start, int length) {
        this.init(vector, start, length);
    }

    public void init(byte[] vector, int start, int length) {
        if (!($assertionsDisabled || start >= 0 && start <= vector.length)) {
            throw new AssertionError((Object)("start=" + start + ",length=" + length + ",vlength=" + vector.length));
        }
        if (!($assertionsDisabled || length >= 0 && length <= vector.length)) {
            throw new AssertionError((Object)("start=" + start + ",length=" + length + ",vlength=" + vector.length));
        }
        if (!$assertionsDisabled && start + length > vector.length) {
            throw new AssertionError((Object)("start=" + start + ",length=" + length + ",vlength=" + vector.length));
        }
        this.vector = vector;
        this.start = start;
        this.length = length;
    }

    public int compareTo(ByteVector target) {
        byte[] tvector = target.vector;
        int tstart = target.start;
        int tlen = target.length;
        int len = this.length < tlen ? this.length : tlen;
        int i = 0;
        while (i < len) {
            int diff = (this.vector[this.start + i] & 0xFF) - (tvector[tstart + i] & 0xFF);
            if (diff != 0) {
                return diff;
            }
            ++i;
        }
        return this.length - tlen;
    }

    public boolean equals(ByteVector target) {
        if (this.length != target.length) {
            return false;
        }
        byte[] tvector = target.vector;
        int tstart = target.start;
        int i = 0;
        while (i < this.length) {
            if (this.vector[this.start + i] != tvector[tstart + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(byte[] target) {
        if (this.length != target.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            if (this.vector[this.start + i] != target[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return new String(this.vector, this.start, this.length);
    }
}

