/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common.vector;

import com.diquest.ir.util.common.CharUtil;

public class CharVector {
    public char[] vector;
    public int start;
    public int length;
    private int hash = 0;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.common.vector.CharVector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public CharVector() {
        this.vector = null;
        this.start = -1;
        this.length = -1;
    }

    public CharVector(String string) {
        char[] charArray = string.toCharArray();
        this.init(charArray, 0, charArray.length);
    }

    public CharVector(char[] vector, int start, int length) {
        this.init(vector, start, length);
    }

    public CharVector(CharVector org) {
        this(org.vector, org.start, org.length);
    }

    public void init(char[] vector, int start, int length) {
        if (!($assertionsDisabled || start >= 0 && start <= vector.length)) {
            throw new AssertionError((Object)("start=" + start + ",length=" + length + ",vlength=" + vector.length));
        }
        if (!$assertionsDisabled && length < 0) {
            throw new AssertionError((Object)("start=" + start + ",length=" + length + ",vlength=" + vector.length));
        }
        if (!$assertionsDisabled && start + length > vector.length) {
            throw new AssertionError((Object)("start=" + start + ",length=" + length + ",vlength=" + vector.length));
        }
        this.vector = vector;
        this.start = start;
        this.length = length;
    }

    public String toString() {
        return new String(this.vector, this.start, this.length);
    }

    public char[] toCharArray() {
        char[] temp = new char[this.length];
        System.arraycopy(this.vector, this.start, temp, 0, this.length);
        return temp;
    }

    public boolean equals(Object obj) {
        CharVector casted = (CharVector)obj;
        if (this.length == casted.length) {
            int castedStart = casted.start;
            int i = this.start;
            while (i < this.start + this.length) {
                if (this.vector[i] != casted.vector[castedStart++]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public boolean equalsIgnoreCase(CharVector casted) {
        if (this.length == casted.length) {
            int castedStart = casted.start;
            int i = this.start;
            while (i < this.start + this.length) {
                char c;
                char d = this.vector[i];
                if ((c = casted.vector[castedStart++]) != d && Character.toUpperCase(c) != Character.toUpperCase(d) && Character.toLowerCase(c) != Character.toLowerCase(d)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = this.hash;
        if (hashCode == 0) {
            int i = this.start;
            while (i < this.start + this.length) {
                hashCode = (hashCode << 5) - hashCode + this.vector[i++];
                ++i;
            }
            this.hash = hashCode = hashCode >= 0 ? hashCode : -hashCode;
        }
        return hashCode;
    }

    /*
     * Unable to fully structure code
     */
    public int relativeIndexOf(CharVector pattern, int offset) {
        if (offset < 0) {
            offset = 0;
        }
        if (pattern.length == 0) {
            if (offset <= this.length) {
                return offset;
            }
            return this.length;
        }
        first = pattern.vector[pattern.start];
        max = this.start + this.length - pattern.length;
        i = offset + this.start;
        ** GOTO lbl24
        {
            ++i;
            do {
                if (i <= max && this.vector[i] != first) continue block0;
                if (i > max) continue;
                j = ++i;
                end = j + pattern.length - 1;
                k = pattern.start + 1;
                while (j < end && this.vector[j] == pattern.vector[k]) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i - 1 - this.start;
lbl24:
                // 3 sources

            } while (i <= max);
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public int indexOf(CharVector pattern, int offset) {
        first = pattern.vector[pattern.start];
        max = this.start + this.length - pattern.length;
        i = offset;
        ** GOTO lbl18
        {
            ++i;
            do {
                if (i <= max && this.vector[i] != first) continue block0;
                if (i > max) continue;
                j = ++i;
                end = j + pattern.length - 1;
                k = pattern.start + 1;
                while (j < end && this.vector[j] == pattern.vector[k]) {
                    ++j;
                    ++k;
                }
                if (j != end) continue;
                return i - 1;
lbl18:
                // 3 sources

            } while (i <= max);
        }
        return -1;
    }

    public CharVector getUpperCharVector() {
        char[] copy = new char[this.length];
        System.arraycopy(this.vector, this.start, copy, 0, this.length);
        CharUtil.toUpperCase(copy);
        return new CharVector(copy, 0, copy.length);
    }

    public char[] getArray() {
        char[] copy = new char[this.length];
        System.arraycopy(this.vector, this.start, copy, 0, this.length);
        return copy;
    }

    public CharVector getCopy() {
        return new CharVector(this);
    }

    public static CharVector valueOf(char[] cs) {
        return new CharVector(cs, 0, cs.length);
    }
}

