/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.common.vector;

import com.diquest.ir.util.common.vector.ByteVector;
import com.diquest.ir.util.common.vector.VectorReader;
import com.diquest.ir.util.common.vector.VectorWriter;
import java.io.IOException;

public class WritableByteVector
extends ByteVector
implements VectorWriter,
VectorReader {
    public int position;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.common.vector.WritableByteVector");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public WritableByteVector() {
    }

    public WritableByteVector(byte[] vector, int start, int length) {
        super(vector, start, length);
        this.position = start;
    }

    public void init(byte[] vector, int start, int length) {
        super.init(vector, start, length);
        this.position = start;
    }

    public void position(int pos) {
        this.position = pos;
    }

    public int position() {
        return this.position;
    }

    public int left() {
        return this.length - (this.position - this.start);
    }

    public int checkVbLength(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        int ret = 1;
        while (n >= 128) {
            n >>>= 7;
            ++ret;
        }
        return ret;
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.vector, this.position, len);
        this.position += len;
    }

    public void read(byte[] b) {
        this.read(b, 0, b.length);
    }

    public void read(byte[] b, int off, int len) {
        System.arraycopy(this.vector, this.position, b, off, len);
        this.position += len;
    }

    public void writeByte(byte b) {
        this.vector[this.position++] = b;
    }

    public int readByte() {
        return this.vector[this.position++] & 0xFF;
    }

    /*
     * Unable to fully structure code
     */
    public void writeVbInt(int n) {
        if (WritableByteVector.$assertionsDisabled || n >= 0) ** GOTO lbl5
        throw new AssertionError(n);
lbl-1000:
        // 1 sources

        {
            this.vector[this.position++] = (byte)(n & 127);
            n >>>= 7;
lbl5:
            // 2 sources

            ** while (n >= 128)
        }
lbl6:
        // 1 sources

        this.vector[this.position++] = (byte)(n | 128);
    }

    public int readVbInt() {
        int shift = 0;
        int n = 0;
        while ((this.vector[this.position] & 0x80) == 0) {
            n |= this.vector[this.position++] << shift;
            shift += 7;
        }
        return n |= (this.vector[this.position++] & 0x7F) << shift;
    }

    /*
     * Unable to fully structure code
     */
    public void writeVbLong(long n) {
        if (WritableByteVector.$assertionsDisabled || n >= 0L) ** GOTO lbl5
        throw new AssertionError(n);
lbl-1000:
        // 1 sources

        {
            this.vector[this.position++] = (byte)(n & 127L);
            n >>>= 7;
lbl5:
            // 2 sources

            ** while (n >= 128L)
        }
lbl6:
        // 1 sources

        this.vector[this.position++] = (byte)(n | 128L);
    }

    public long readVbLong() {
        int shift = 0;
        long n = 0L;
        while ((this.vector[this.position] & 0x80) == 0) {
            n |= (long)this.vector[this.position++] << shift;
            shift += 7;
        }
        return n |= (long)(this.vector[this.position++] & 0x7F) << shift;
    }

    public void writeInt(int value) {
        this.vector[this.position++] = (byte)((value & 0xFF000000) >>> 24);
        this.vector[this.position++] = (byte)((value & 0xFF0000) >>> 16);
        this.vector[this.position++] = (byte)((value & 0xFF00) >>> 8);
        this.vector[this.position++] = (byte)((value & 0xFF) >>> 0);
    }

    public int readInt() {
        return (this.vector[this.position++] & 0xFF) << 24 | (this.vector[this.position++] & 0xFF) << 16 | (this.vector[this.position++] & 0xFF) << 8 | (this.vector[this.position++] & 0xFF) << 0;
    }

    public void writeShortInt(int value) {
        if (!($assertionsDisabled || value >= 0 && value <= 65535)) {
            throw new AssertionError(value);
        }
        this.vector[this.position++] = (byte)((value & 0xFF00) >>> 8);
        this.vector[this.position++] = (byte)((value & 0xFF) >>> 0);
    }

    public int readShortInt() {
        return (this.vector[this.position++] & 0xFF) << 8 | (this.vector[this.position++] & 0xFF) << 0;
    }

    public void writeLong(long value) {
        this.vector[this.position++] = (byte)((value & 0xFF00000000000000L) >>> 56);
        this.vector[this.position++] = (byte)((value & 0xFF000000000000L) >>> 48);
        this.vector[this.position++] = (byte)((value & 0xFF0000000000L) >>> 40);
        this.vector[this.position++] = (byte)((value & 0xFF00000000L) >>> 32);
        this.vector[this.position++] = (byte)((value & 0xFF000000L) >>> 24);
        this.vector[this.position++] = (byte)((value & 0xFF0000L) >>> 16);
        this.vector[this.position++] = (byte)((value & 0xFF00L) >>> 8);
        this.vector[this.position++] = (byte)((value & 0xFFL) >>> 0);
    }

    public long readLong() {
        return (long)(this.vector[this.position++] & 0xFF) << 56 | (long)(this.vector[this.position++] & 0xFF) << 48 | (long)(this.vector[this.position++] & 0xFF) << 40 | (long)(this.vector[this.position++] & 0xFF) << 32 | (long)(this.vector[this.position++] & 0xFF) << 24 | (long)(this.vector[this.position++] & 0xFF) << 16 | (long)(this.vector[this.position++] & 0xFF) << 8 | (long)(this.vector[this.position++] & 0xFF) << 0;
    }

    public void writeString(String value) throws IOException {
        if (value == null) {
            this.vector[this.position++] = 0;
        } else {
            this.vector[this.position++] = 1;
            int length = value.length();
            this.writeVbInt(length);
            int i = 0;
            while (i < length) {
                char c = value.charAt(i);
                this.vector[this.position++] = (byte)((c & 0xFF00) >>> 8);
                this.vector[this.position++] = (byte)((c & 0xFF) >>> 0);
                ++i;
            }
        }
    }
}

