/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.compress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

public class File2GZIP {
    private File _file;

    public File2GZIP() {
    }

    public File2GZIP(File file) {
        this._file = file;
    }

    public File2GZIP(String filepath) {
        this._file = new File(filepath);
    }

    public File convert() throws IOException {
        return this.convert(this.getOutFileName());
    }

    public File convert(String outUri) throws IOException {
        GZIPOutputStream out = this.prepareOutputStream(outUri);
        FileInputStream in = this.openInputStream();
        this.readAndWrite(out, in);
        this.closeStream(out, in);
        File gzipFile = new File(this.getOutFileName());
        this.deleteSource();
        return gzipFile;
    }

    public File convert(File file) throws IOException {
        this.reloadFile(file);
        return this.convert();
    }

    private void reloadFile(File file) {
        this._file = file;
    }

    private void closeStream(GZIPOutputStream out, FileInputStream in) throws IOException {
        in.close();
        out.finish();
        out.close();
    }

    private void readAndWrite(GZIPOutputStream out, FileInputStream in) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    private String getOutFileName() {
        String outFileName = String.valueOf(this._file.getAbsolutePath()) + ".gz";
        return outFileName;
    }

    private FileInputStream openInputStream() throws FileNotFoundException {
        return new FileInputStream(this._file);
    }

    private GZIPOutputStream prepareOutputStream(String outFileName) throws IOException {
        GZIPOutputStream out = null;
        out = new GZIPOutputStream(new FileOutputStream(outFileName));
        return out;
    }

    public boolean deleteSource() {
        boolean isDeleted = false;
        if (this._file != null) {
            isDeleted = this._file.delete();
        }
        return isDeleted;
    }
}

