/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.compress;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;

public class GZIPUncompressor {
    private File _file;

    public GZIPUncompressor() {
    }

    public GZIPUncompressor(File file) {
        this._file = file;
    }

    public GZIPUncompressor(String filepath) {
        if (!this.isGzipFile(filepath)) {
            this._file = new File(filepath);
        }
    }

    public void reloadFile(File file) {
        this._file = file;
    }

    public File uncompress2file() throws FileNotFoundException, IOException {
        File outFile = null;
        GZIPInputStream in = this.openCompressedFile(this._file);
        outFile = new File(this.getFileName(this._file.getAbsolutePath()));
        FileOutputStream out = this.warp(outFile);
        this.readAndWrite(in, out);
        this.close(in, out);
        return outFile;
    }

    public File uncompress2file(File file) throws FileNotFoundException, IOException {
        this.reloadFile(file);
        File outFile = null;
        GZIPInputStream in = this.openCompressedFile(this._file);
        outFile = new File(this.getFileName(this._file.getAbsolutePath()));
        FileOutputStream out = this.warp(outFile);
        this.readAndWrite(in, out);
        this.close(in, out);
        return outFile;
    }

    public File uncompress2file(String filename) throws FileNotFoundException, IOException {
        this.reloadFile(new File(filename));
        File outFile = null;
        GZIPInputStream in = this.openCompressedFile(this._file);
        outFile = new File(this.getFileName(this._file.getAbsolutePath()));
        FileOutputStream out = this.warp(outFile);
        this.readAndWrite(in, out);
        this.close(in, out);
        return outFile;
    }

    public String uncompress2contents() throws FileNotFoundException, IOException {
        GZIPInputStream in = this.openCompressedFile(this._file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.readAndWrite(in, out);
        this.close(in, out);
        return new String(out.toByteArray());
    }

    public String uncompress2contents(File file) throws FileNotFoundException, IOException {
        this.reloadFile(file);
        GZIPInputStream in = this.openCompressedFile(this._file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.readAndWrite(in, out);
        this.close(in, out);
        return new String(out.toByteArray());
    }

    public String uncompress2contents(String filename) throws FileNotFoundException, IOException {
        this.reloadFile(new File(filename));
        GZIPInputStream in = this.openCompressedFile(this._file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.readAndWrite(in, out);
        this.close(in, out);
        return new String(out.toByteArray());
    }

    private FileOutputStream warp(File outFile) throws FileNotFoundException {
        FileOutputStream out = null;
        out = new FileOutputStream(outFile);
        return out;
    }

    private void close(GZIPInputStream in, OutputStream out) throws IOException {
        in.close();
        out.close();
    }

    private void readAndWrite(GZIPInputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    private GZIPInputStream openCompressedFile(File inFile) throws FileNotFoundException, IOException {
        GZIPInputStream in = null;
        in = new GZIPInputStream(new FileInputStream(inFile));
        return in;
    }

    private boolean isGzipFile(String filepath) {
        return this.getExtension(filepath).equalsIgnoreCase("gz");
    }

    private String getExtension(String f) {
        String ext = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            ext = f.substring(i + 1);
        }
        return ext;
    }

    private String getFileName(String f) {
        String fname = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            fname = f.substring(0, i);
        }
        return fname;
    }
}

