/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.compress;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Zip {
    static final int BUFFER = 1024;
    private ZipOutputStream outStream = null;
    private File in;
    File out;
    private File root = null;

    public Zip() {
    }

    public Zip(File in, File out) throws FileNotFoundException {
        this.in = in;
        this.out = out;
        this.root = in.getParentFile();
        if (!out.getParentFile().isDirectory()) {
            out.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(out);
        this.outStream = new ZipOutputStream(new BufferedOutputStream(fos));
        this.outStream.setMethod(8);
    }

    public Zip(String in, File out) throws FileNotFoundException {
        this(new File(in), out);
    }

    public boolean compress() throws IOException {
        return this.compressElement(this.in);
    }

    private boolean compressElement(File in) throws IOException {
        if (in.isDirectory()) {
            String[] children = in.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return !Zip.this.out.getName().equals(name);
                }
            });
            int i = 0;
            while (i < children.length) {
                boolean success = this.compressElement(new File(in, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        } else {
            int count;
            byte[] data = new byte[1024];
            String entryName = this.getEntry(this.root, in);
            BufferedInputStream origin = new BufferedInputStream(new FileInputStream(in), 1024);
            ZipEntry entry = new ZipEntry(entryName);
            this.outStream.putNextEntry(entry);
            while ((count = origin.read(data, 0, 1024)) != -1) {
                this.outStream.write(data, 0, count);
            }
            origin.close();
            this.outStream.flush();
            return true;
        }
        return true;
    }

    public void close() throws IOException {
        this.outStream.close();
    }

    public String getEntry(File base, File in) {
        return in.getAbsolutePath().substring(base.getAbsolutePath().length());
    }
}

