/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.encode;

import java.io.UnsupportedEncodingException;

public class Encoder {
    private static final String DEFAULT_CHARSET = "EUC_KR";

    public static String encodeAuto(String value) {
        return Encoder.encodeAuto(value, DEFAULT_CHARSET);
    }

    public static String encodeAuto(String value, String encoding) {
        return Encoder.encodeAuto(value, encoding, false);
    }

    public static String encodeAuto(String value, boolean asItIs) {
        return Encoder.encodeAuto(value, DEFAULT_CHARSET, asItIs);
    }

    public static String encodeAuto(String value, String encoding, boolean asItIs) {
        if (value == null) {
            if (asItIs) {
                return null;
            }
            return "";
        }
        boolean is8859_1 = false;
        int valueLength = value.length();
        int asciiLength = 0;
        int i = 0;
        while (i < valueLength) {
            char c = value.charAt(i);
            if (c > '\u00ff') {
                is8859_1 = false;
                break;
            }
            if (c > '\u0080') {
                is8859_1 = true;
            } else {
                ++asciiLength;
            }
            ++i;
        }
        if (is8859_1) {
            try {
                byte[] bytes = value.getBytes("8859_1");
                String utfString = Encoder.checkUTF8Bytes(bytes);
                value = utfString == null ? new String(bytes, encoding) : utfString;
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
        return value;
    }

    private static String checkUTF8Bytes(byte[] bytes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            if ((bytes[i] & 0x80) == 0) {
                buffer.append((char)bytes[i]);
                if (bytes[i] < 1 || bytes[i] > 127) {
                    return null;
                }
            } else {
                char c;
                if ((bytes[i] & 0x40) != 64) {
                    return null;
                }
                if ((bytes[i] & 0x20) == 0) {
                    if (++i >= bytes.length || (bytes[i] & 0xC0) != 128) {
                        return null;
                    }
                    c = (char)(((bytes[i - 1] & 0x1F) << 6) + bytes[i] & 0x3F);
                    buffer.append(c);
                    if (c != '\u0000' && (c < '\u0080' || c > '\u07ff')) {
                        return null;
                    }
                } else {
                    if ((bytes[i] & 0xF0) != 224) {
                        return null;
                    }
                    if (++i >= bytes.length || (bytes[i] & 0xC0) != 128) {
                        return null;
                    }
                    if (++i >= bytes.length || (bytes[i] & 0xC0) != 128) {
                        return null;
                    }
                    c = (char)(((bytes[i - 2] & 0xF) << 12) + ((bytes[i - 1] & 0x3F) << 6) + (bytes[i] & 0x3F));
                    buffer.append(c);
                    if (c < '\u0800' || c > '\uffff') {
                        return null;
                    }
                }
            }
            ++i;
        }
        return new String(buffer);
    }
}

