/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.encode;

public class HexaEncoder {
    static final int[] CODE_VALUE = new int[128];
    private static final char[] HEXA_SYMBOL;

    static {
        HexaEncoder.CODE_VALUE[48] = 0;
        HexaEncoder.CODE_VALUE[49] = 1;
        HexaEncoder.CODE_VALUE[50] = 2;
        HexaEncoder.CODE_VALUE[51] = 3;
        HexaEncoder.CODE_VALUE[52] = 4;
        HexaEncoder.CODE_VALUE[53] = 5;
        HexaEncoder.CODE_VALUE[54] = 6;
        HexaEncoder.CODE_VALUE[55] = 7;
        HexaEncoder.CODE_VALUE[56] = 8;
        HexaEncoder.CODE_VALUE[57] = 9;
        HexaEncoder.CODE_VALUE[65] = 10;
        HexaEncoder.CODE_VALUE[66] = 11;
        HexaEncoder.CODE_VALUE[67] = 12;
        HexaEncoder.CODE_VALUE[68] = 13;
        HexaEncoder.CODE_VALUE[69] = 14;
        HexaEncoder.CODE_VALUE[70] = 15;
        HEXA_SYMBOL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static void charToHexa(char n, char[] out, int offset) {
        out[offset + 0] = HEXA_SYMBOL[(n & 0xF000) >>> 12];
        out[offset + 1] = HEXA_SYMBOL[(n & 0xF00) >>> 8];
        out[offset + 2] = HEXA_SYMBOL[(n & 0xF0) >>> 4];
        out[offset + 3] = HEXA_SYMBOL[(n & 0xF) >>> 0];
    }

    private static char hexaToChar(char[] in, int offset) {
        char first = in[offset + 0];
        char second = in[offset + 1];
        char third = in[offset + 2];
        char forth = in[offset + 3];
        if (first > '\u007f' || second > '\u007f' || third > '\u007f' || forth > '\u007f') {
            return '\u0000';
        }
        return (char)(CODE_VALUE[first] << 12 | CODE_VALUE[second] << 8 | CODE_VALUE[third] << 4 | CODE_VALUE[forth]);
    }

    public static String encodeString(String str) {
        char[] out = new char[str.length() * 4];
        int i = 0;
        while (i < str.length()) {
            HexaEncoder.charToHexa(str.charAt(i), out, i * 4);
            ++i;
        }
        return new String(out);
    }

    public static String decodeString(String str) {
        int length = str.length();
        if (length % 4 != 0) {
            return null;
        }
        char[] in = str.toCharArray();
        char[] out = new char[length /= 4];
        int i = 0;
        while (i < length) {
            out[i] = HexaEncoder.hexaToChar(in, i * 4);
            ++i;
        }
        return new String(out);
    }
}

