/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.encode.detect;

import com.diquest.ir.util.encode.detect.CharsetToolkit;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class SmartEncodingInputStream
extends InputStream {
    private InputStream is;
    private int bufferLength;
    private boolean enforce8Bit;
    private Charset defaultCharset;
    private byte[] buffer;
    private int counter;
    private Charset charset;
    public static final int BUFFER_LENGTH_2KB = 2048;
    public static final int BUFFER_LENGTH_4KB = 4096;
    public static final int BUFFER_LENGTH_8KB = 8192;

    public SmartEncodingInputStream(InputStream is, int bufferLength, Charset defaultCharset, boolean enforce8Bit) throws IOException {
        this.is = is;
        this.bufferLength = bufferLength;
        this.enforce8Bit = enforce8Bit;
        this.buffer = new byte[bufferLength];
        this.counter = 0;
        this.bufferLength = is.read(this.buffer);
        this.defaultCharset = defaultCharset;
        CharsetToolkit charsetToolkit = new CharsetToolkit(this.buffer, defaultCharset);
        charsetToolkit.setEnforce8Bit(enforce8Bit);
        this.charset = charsetToolkit.guessEncoding();
    }

    public final Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public final boolean isEnforce8Bit() {
        return this.enforce8Bit;
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength, Charset defaultCharset) throws IOException {
        this(is, bufferLength, defaultCharset, true);
    }

    public SmartEncodingInputStream(InputStream is, Charset defaultCharset) throws IOException {
        this(is, 4096, defaultCharset, true);
    }

    public SmartEncodingInputStream(InputStream is, int bufferLength) throws IOException {
        this(is, bufferLength, null, true);
    }

    public SmartEncodingInputStream(InputStream is) throws IOException {
        this(is, 4096, null, true);
    }

    public int read() throws IOException {
        if (this.counter < this.bufferLength) {
            return this.buffer[this.counter++] & 0xFF;
        }
        return this.is.read();
    }

    public Reader getReader() {
        return new InputStreamReader((InputStream)this, this.charset);
    }

    public Charset getEncoding() {
        return this.charset;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream fis = new FileInputStream("D:\\M2S\\encoding\\news.irt.ms949.euc-kr");
        SmartEncodingInputStream smartIS = new SmartEncodingInputStream(fis);
        System.err.println("The charset of this input stream is: " + smartIS.getEncoding().displayName());
        Reader reader = smartIS.getReader();
        BufferedReader bufReader = new BufferedReader(reader);
        bufReader.close();
    }
}

