/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import com.diquest.ir.util.io.RepositionableStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;

public class FastBufferedInputStream
extends InputStream
implements RepositionableStream {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    protected byte[] buffer;
    protected int pos;
    protected int avail;
    protected InputStream is;
    private FileChannel fileChannel;
    private RepositionableStream rs;

    public FastBufferedInputStream(InputStream is, int bufSize) {
        this.is = is;
        this.buffer = new byte[bufSize];
        if (is instanceof RepositionableStream) {
            this.rs = (RepositionableStream)((Object)is);
        }
        if (this.rs == null) {
            try {
                this.fileChannel = (FileChannel)is.getClass().getMethod("getChannel", new Class[0]).invoke((Object)is, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public FastBufferedInputStream(InputStream is) {
        this(is, 16384);
    }

    public int read() throws IOException {
        if (this.avail == 0) {
            this.avail = this.is.read(this.buffer);
            if (this.avail <= 0) {
                this.avail = 0;
                return -1;
            }
            this.pos = 0;
        }
        --this.avail;
        return this.buffer[this.pos++] & 0xFF;
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        if (length <= this.avail) {
            System.arraycopy(this.buffer, this.pos, b, offset, length);
            this.pos += length;
            this.avail -= length;
            return length;
        }
        int head = this.avail;
        System.arraycopy(this.buffer, this.pos, b, offset, head);
        this.avail = 0;
        int residual = (length -= head) % this.buffer.length;
        int result = this.is.read(b, offset += head, length - residual);
        if (result < length - residual) {
            this.pos = 0;
            this.avail = 0;
            return result < 0 ? (head != 0 ? head : -1) : result + head;
        }
        this.avail = this.is.read(this.buffer);
        if (this.avail < 0) {
            this.avail = 0;
            return result + head > 0 ? result + head : -1;
        }
        this.pos = Math.min(this.avail, residual);
        System.arraycopy(this.buffer, 0, b, offset + length - residual, this.pos);
        this.avail -= this.pos;
        return result + head + this.pos;
    }

    public void position(long newPosition) throws IOException {
        long position = this.position();
        if (newPosition <= position + (long)this.avail && newPosition >= position - (long)this.pos) {
            this.pos = (int)((long)this.pos + (newPosition - position));
            this.avail = (int)((long)this.avail - (newPosition - position));
            return;
        }
        int residual = (int)(newPosition % (long)this.buffer.length);
        if (this.rs != null) {
            this.rs.position(newPosition - (long)residual);
        } else if (this.fileChannel != null) {
            this.fileChannel.position(newPosition - (long)residual);
        } else {
            throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
        }
        this.avail = Math.max(0, this.is.read(this.buffer));
        this.pos = Math.min(residual, this.avail);
        this.avail -= this.pos;
    }

    public long position() throws IOException {
        if (this.rs != null) {
            return this.rs.position() - (long)this.avail;
        }
        if (this.fileChannel != null) {
            return this.fileChannel.position() - (long)this.avail;
        }
        throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
    }

    public long skip(long n) throws IOException {
        int residual;
        long result;
        if (n <= (long)this.avail) {
            int m = (int)n;
            this.pos += m;
            this.avail -= m;
            return n;
        }
        int head = this.avail;
        this.avail = 0;
        if ((result = this.is.skip((n -= (long)head) - (long)(residual = (int)(n % (long)this.buffer.length)))) < n - (long)residual) {
            this.avail = 0;
            return result + (long)head;
        }
        this.avail = Math.max(this.is.read(this.buffer), 0);
        this.pos = Math.min(residual, this.avail);
        this.avail -= this.pos;
        return result + (long)head + (long)this.pos;
    }

    public int available() throws IOException {
        return this.is.available() + this.avail;
    }

    public void close() throws IOException {
        if (this.is == null) {
            return;
        }
        if (this.is != System.in) {
            this.is.close();
        }
        this.is = null;
        this.buffer = null;
    }
}

