/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FastBufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public FastBufferedOutputStream(OutputStream out) {
        this(out, 512);
    }

    public FastBufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public void writeInt(int value) throws IOException {
        if (4 > this.buf.length - this.count) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)((value & 0xFF000000) >>> 24);
        this.buf[this.count++] = (byte)((value & 0xFF0000) >>> 16);
        this.buf[this.count++] = (byte)((value & 0xFF00) >>> 8);
        this.buf[this.count++] = (byte)(value & 0xFF);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

