/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import com.diquest.ir.util.common.ArrayUtil;
import java.io.OutputStream;

public class FastByteArrayOutputStream
extends OutputStream {
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public byte[] array;
    public int length;

    public FastByteArrayOutputStream() {
        this(16);
    }

    public FastByteArrayOutputStream(int initialCapacity) {
        this.array = new byte[initialCapacity];
    }

    public FastByteArrayOutputStream(byte[] a) {
        this.array = a;
    }

    public byte[] toByteArray() {
        byte[] out = new byte[this.length];
        System.arraycopy(this.array, 0, out, 0, this.length);
        return out;
    }

    public void reset() {
        this.length = 0;
    }

    public void trim() {
        this.array = ArrayUtil.trimToCapacity(this.array, this.length);
    }

    public void write(int b) {
        if (this.length == this.array.length) {
            this.array = ArrayUtil.ensureCapacity(this.array, Math.max(this.length, 1) * 2);
        }
        this.array[this.length++] = (byte)b;
    }

    public void position(int l) {
        this.length = l;
    }

    public int position() {
        return this.length;
    }

    public byte[] array() {
        return this.array;
    }
}

