/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import com.diquest.ir.util.common.BitUtil;
import com.diquest.ir.util.io.NullInputStream;
import com.diquest.ir.util.io.RepositionableStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.channels.FileChannel;

public class InputBitStream {
    public static final int UNGET_BUFFER_SIZE = 16;
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final boolean debug = false;
    private InputStream is;
    private long readBits;
    private int current;
    private byte[] buffer;
    private boolean noBuffer;
    private int fill;
    private int pos;
    private int avail;
    private long position;
    private byte[] ungetBytes;
    private int ungetCount = 0;
    private boolean overflow = false;
    private boolean pastEOF = false;
    private FileChannel fileChannel;
    private RepositionableStream rs;

    public InputBitStream(InputStream is) {
        this(is, 16384);
    }

    public InputBitStream(InputStream is, int bufSize) {
        this.is = is;
        this.noBuffer = bufSize == 0;
        if (!this.noBuffer) {
            this.buffer = new byte[bufSize];
        }
        if (is instanceof RepositionableStream) {
            this.rs = (RepositionableStream)((Object)is);
        }
        if (this.rs == null) {
            try {
                this.fileChannel = (FileChannel)is.getClass().getMethod("getChannel", new Class[0]).invoke((Object)is, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    public InputBitStream(byte[] a) {
        this.is = NullInputStream.getInstance();
        this.buffer = a;
        this.avail = a.length;
    }

    public void flush() {
        this.position += (long)this.pos;
        this.avail = 0;
        this.pos = 0;
        this.fill = 0;
        this.ungetCount = 0;
    }

    public void close() throws IOException {
        if (this.is == null) {
            return;
        }
        if (this.is != System.in) {
            this.is.close();
        }
        this.is = null;
        this.buffer = null;
        this.ungetBytes = null;
    }

    public void overflow(boolean overflow) {
        this.overflow = overflow;
    }

    public long available() throws IOException {
        return (this.is.available() + this.ungetCount + this.avail) * 8 + this.fill;
    }

    public boolean overflow() {
        return this.overflow;
    }

    public boolean pastEOF() {
        return this.pastEOF;
    }

    public long readBits() {
        return this.readBits;
    }

    public void readBits(long readBits) {
        this.readBits = readBits;
    }

    private int read() throws IOException {
        if (this.ungetCount > 0) {
            return this.ungetBytes[--this.ungetCount] & 0xFF;
        }
        if (this.pastEOF) {
            return 0;
        }
        if (this.noBuffer) {
            int t = this.is.read();
            if (t == -1) {
                if (this.overflow) {
                    this.pastEOF = true;
                    return 0;
                }
                throw new EOFException();
            }
            ++this.position;
            return t;
        }
        if (this.avail == 0) {
            this.avail = this.is.read(this.buffer);
            if (this.avail == -1) {
                if (this.overflow) {
                    this.avail = 0;
                    this.pastEOF = true;
                    return 0;
                }
                throw new EOFException();
            }
            this.position += (long)this.pos;
            this.pos = 0;
        }
        --this.avail;
        return this.buffer[this.pos++] & 0xFF;
    }

    private int readFromCurrent(int len) throws IOException {
        if (this.fill == 0 && len != 0) {
            this.current = this.read() & 0xFF;
            this.fill = 8;
        }
        int x = this.current >>> (this.fill -= len);
        this.current &= (1 << this.fill) - 1;
        this.readBits += (long)len;
        return x;
    }

    public void align() throws IOException {
        if (this.fill != 0) {
            this.readFromCurrent(this.fill);
        }
    }

    public void ungetBit(boolean bit) throws IOException {
        this.unget(bit ? 1 : 0);
    }

    public void unget(boolean bit) throws IOException {
        this.ungetBit(bit);
    }

    public void ungetBit(int bit) throws IOException {
        if (bit < 0 || bit > 1) {
            throw new IllegalArgumentException("The argument " + bit + " is not a bit.");
        }
        this.current = bit != 0 ? (this.current |= 1 << this.fill) : (this.current &= ~(1 << this.fill));
        ++this.fill;
        --this.readBits;
        if (this.fill == 8) {
            if (this.ungetCount == 16) {
                throw new IOException("Unget buffer overflow.");
            }
            if (this.ungetBytes == null) {
                this.ungetBytes = new byte[16];
            }
            this.ungetBytes[this.ungetCount++] = (byte)this.current;
            this.fill = 0;
            this.current = 0;
        }
    }

    public void unget(int bit) throws IOException {
        this.ungetBit(bit);
    }

    public void ungetLong(long x, int len) throws IOException {
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot unget " + len + " bits from a long.");
        }
        int i = len;
        while (i-- != 0) {
            this.unget((int)(x & 1L));
            x >>>= 1;
        }
    }

    public void ungetInt(int x, int len) throws IOException {
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot unget " + len + " bits from an integer.");
        }
        int i = len;
        while (i-- != 0) {
            this.unget(x & 1);
            x >>>= 1;
        }
    }

    public void read(byte[] bits, int len) throws IOException {
        if (len <= this.fill) {
            bits[0] = (byte)(this.readFromCurrent(len) << 8 - len);
            return;
        }
        int shift = this.fill;
        bits[0] = (byte)(this.readFromCurrent(shift) << 8 - shift);
        int j = 0;
        int i = (len -= shift) >> 3;
        while (i-- != 0) {
            int b = this.read();
            this.readBits += 8L;
            int n = j++;
            bits[n] = (byte)(bits[n] | (b & 0xFF) >>> shift);
            bits[j] = (byte)(b << 8 - shift);
        }
        int queue = len & 7;
        if (queue != 0) {
            if (queue <= 8 - shift) {
                int n = j;
                bits[n] = (byte)(bits[n] | (byte)(this.readFromCurrent(queue) << 8 - shift - queue));
            } else {
                int n = j;
                bits[n] = (byte)(bits[n] | (byte)this.readFromCurrent(8 - shift));
                bits[j + 1] = (byte)(this.readFromCurrent(queue + shift - 8) << 16 - shift - queue);
            }
        }
    }

    public int readBit() throws IOException {
        return this.readFromCurrent(1);
    }

    public int readInt(int len) throws IOException {
        int x = 0;
        if (len < 0 || len > 32) {
            throw new IllegalArgumentException("You cannot read " + len + " bits into an integer.");
        }
        if (len == 0) {
            return 0;
        }
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x <<= 8;
            x |= this.read() & 0xFF;
            this.readBits += 8L;
        }
        return x << (len &= 7) | this.readFromCurrent(len);
    }

    public long readLong(int len) throws IOException {
        long x = 0L;
        if (len < 0 || len > 64) {
            throw new IllegalArgumentException("You cannot read " + len + " bits into a long.");
        }
        if (len == 0) {
            return 0L;
        }
        if (len <= this.fill) {
            return this.readFromCurrent(len);
        }
        x = this.readFromCurrent(this.fill);
        int i = (len -= this.fill) >> 3;
        while (i-- != 0) {
            x <<= 8;
            x |= (long)(this.read() & 0xFF);
            this.readBits += 8L;
        }
        return x << (len &= 7) | (long)this.readFromCurrent(len);
    }

    public long skip(long n) throws IOException {
        if (n <= (long)this.fill) {
            if (n < 0L) {
                throw new IllegalArgumentException("Negative bit skip value: " + n);
            }
            this.readFromCurrent((int)n);
            return n;
        }
        int t = this.fill;
        long prevReadBits = this.readBits;
        this.readFromCurrent(t);
        long nb = (n -= (long)t) >> 3;
        if (nb <= (long)this.avail) {
            this.pos += (int)nb;
            this.avail -= (int)nb;
            this.readBits += nb << 3;
        } else {
            n -= (long)(this.avail << 3);
            this.readBits += (long)(this.avail << 3);
            long toSkip = nb - (long)this.avail;
            long skipped = this.is.skip(toSkip);
            this.position += (long)(this.avail + this.pos) + skipped;
            this.pos = 0;
            this.avail = 0;
            this.readBits += skipped << 3;
            if (skipped != toSkip) {
                return this.readBits - prevReadBits;
            }
        }
        this.readFromCurrent((int)(n & 7L));
        return this.readBits - prevReadBits;
    }

    public void position(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Illegal position: " + position);
        }
        long delta = (position >> 3) - (this.position + (long)this.pos);
        if (delta <= (long)this.avail && delta >= (long)(-this.pos)) {
            this.avail = (int)((long)this.avail - delta);
            this.pos = (int)((long)this.pos + delta);
            this.ungetCount = 0;
            this.fill = 0;
        } else if (this.rs != null) {
            this.flush();
            this.position = position >> 3;
            this.rs.position(this.position);
        } else if (this.fileChannel != null) {
            this.flush();
            this.position = position >> 3;
            this.fileChannel.position(this.position);
        } else {
            throw new UnsupportedOperationException("position() can only be called if the underlying byte stream implements the RepositionableStream interface or if the getChannel() method of the underlying byte stream exists and returns a FileChannel");
        }
        this.skip(position & 7L);
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }

    public void mark(int readLimit) throws IOException {
        if (this.fill != 0) {
            throw new IOException("You cannot mark a bit stream outside of byte boundaries.");
        }
        this.is.mark(readLimit);
    }

    public void reset() throws IOException {
        this.flush();
        this.is.reset();
    }

    public int readUnary() throws IOException {
        int x = 0;
        if (this.current != 0) {
            x = this.fill - BitUtil.BYTEMSB[this.current] - 1;
            this.readFromCurrent(x + 1);
            return x;
        }
        x += this.fill;
        this.readBits += (long)this.fill;
        while ((this.current = this.read()) == 0) {
            x += 8;
            this.readBits += 8L;
        }
        this.fill = BitUtil.BYTEMSB[this.current & 0xFF];
        int z = 7 - this.fill;
        this.current &= (1 << this.fill) - 1;
        this.readBits += (long)(z + 1);
        return x += z;
    }

    public long readLongUnary() throws IOException {
        long x = 0L;
        if (this.current != 0) {
            x = this.fill - BitUtil.BYTEMSB[this.current] - 1;
            this.readFromCurrent((int)(x + 1L));
            return x;
        }
        x += (long)this.fill;
        while ((this.current = this.read()) == 0) {
            x += 8L;
            this.readBits += 8L;
        }
        this.fill = BitUtil.BYTEMSB[this.current & 0xFF];
        int z = 7 - this.fill;
        this.current &= (1 << this.fill) - 1;
        this.readBits += (long)(z + 1);
        return x += (long)z;
    }

    public int readGamma() throws IOException {
        int msb = this.readUnary();
        return msb == 0 ? 0 : (1 << msb | this.readInt(msb)) - 1;
    }

    public long readLongGamma() throws IOException {
        int msb = this.readUnary();
        return msb == 0 ? 0L : (1L << msb | this.readLong(msb)) - 1L;
    }

    public int readDelta() throws IOException {
        int msb = this.readGamma();
        return msb == 0 ? 0 : (1 << msb | this.readInt(msb)) - 1;
    }

    public long readLongDelta() throws IOException {
        int msb = this.readGamma();
        return msb == 0 ? 0L : (1L << msb | this.readLong(msb)) - 1L;
    }

    public int readMinimalBinary(int b) throws IOException {
        return this.readMinimalBinary(b, BitUtil.mostSignificantBit(b));
    }

    public int readMinimalBinary(int b, int log2b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        int m = (1 << log2b + 1) - b;
        int x = this.readInt(log2b);
        if (x < m) {
            return x;
        }
        return (x << 1) + this.readBit() - m;
    }

    public long readLongMinimalBinary(long b) throws IOException {
        return this.readLongMinimalBinary(b, BitUtil.mostSignificantBit(b));
    }

    public long readLongMinimalBinary(long b, int log2b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The bound " + b + " is not positive");
        }
        long m = (1L << log2b + 1) - b;
        long x = this.readLong(log2b);
        if (x < m) {
            return x;
        }
        return (x << 1) + (long)this.readBit() - m;
    }

    public int readGolomb(int b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The base " + b + " is not positive");
        }
        return this.readGolomb(b, BitUtil.mostSignificantBit(b));
    }

    public int readGolomb(int b, int log2b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The base " + b + " is not positive");
        }
        int q = this.readUnary() * b;
        return q + this.readMinimalBinary(b, log2b);
    }

    public long readLongGolomb(long b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The base " + b + " is not positive");
        }
        return this.readLongGolomb(b, BitUtil.mostSignificantBit(b));
    }

    public long readLongGolomb(long b, int log2b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The base " + b + " is not positive");
        }
        long q = (long)this.readUnary() * b;
        return q + this.readLongMinimalBinary(b, log2b);
    }

    public int readSkewedGolomb(int b) throws IOException {
        if (b < 1) {
            throw new IllegalArgumentException("The base " + b + " is not positive");
        }
        int M = ((1 << this.readUnary() + 1) - 1) * b;
        int m = M / (2 * b) * b;
        return m + this.readMinimalBinary(M - m);
    }

    public long readLongSkewedGolomb(long b) throws IOException {
        if (b < 1L) {
            throw new IllegalArgumentException("The base " + b + " is not positive");
        }
        long M = (long)((1 << this.readUnary() + 1) - 1) * b;
        long m = M / (2L * b) * b;
        return m + this.readLongMinimalBinary(M - m);
    }

    public int readZeta(int k) throws IOException {
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        int h = this.readUnary();
        int left = 1 << h * k;
        int m = this.readInt(h * k + k - 1);
        if (m < left) {
            return m + left - 1;
        }
        return (m << 1) + this.readBit() - 1;
    }

    public long readLongZeta(int k) throws IOException {
        if (k < 1) {
            throw new IllegalArgumentException("The shrinking factor " + k + " is not positive");
        }
        int h = this.readUnary();
        long left = 1 << h * k;
        long m = this.readLong(h * k + k - 1);
        if (m < left) {
            return m + left - 1L;
        }
        return (m << 1) + (long)this.readBit() - 1L;
    }

    public int readNibble() throws IOException {
        int b;
        int x = 0;
        do {
            x <<= 3;
            b = this.readBit();
            x |= this.readInt(3);
        } while (b == 0);
        return x;
    }

    public long readLongNibble() throws IOException {
        int b;
        long x = 0L;
        do {
            x <<= 3;
            b = this.readBit();
            x |= (long)this.readInt(3);
        } while (b == 0);
        return x;
    }
}

