/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VirtualFileInputStream
extends InputStream {
    private final String prefix;
    private boolean islast;
    private FileInputStream fis;
    private int filesizeLimit;
    private int vsize;
    private int voffset;
    private int sequence;
    private byte[] buffer;
    private int boffset;
    private int bsize;
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final int INITIAL_FILESIZE_LIMIT = 0x40000000;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.io.VirtualFileInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public VirtualFileInputStream(String name) throws IOException {
        this(name, 0x40000000, 4096);
    }

    public VirtualFileInputStream(String name, int vlimit) throws IOException {
        this(name, vlimit, 4096);
    }

    public VirtualFileInputStream(String prefix, int filesizeLimit, int bufferSize) throws IOException {
        if (bufferSize < 16) {
            throw new IllegalArgumentException("Illegal buffer size(cannot be smaller than 16) : " + bufferSize);
        }
        this.prefix = prefix;
        this.filesizeLimit = filesizeLimit;
        this.buffer = new byte[bufferSize];
        this.sequence = 0;
        if (!this.getNextFile()) {
            throw new IOException("Cannot open sub-file.");
        }
        this.fillBuffer();
    }

    private File getSubFile(int seq) {
        if (seq == 0) {
            return new File(this.prefix);
        }
        return new File(String.valueOf(this.prefix) + "." + seq);
    }

    private boolean getNextFile() throws IOException {
        File virtualFile;
        if (this.islast) {
            return false;
        }
        if (this.fis != null) {
            this.fis.close();
            this.fis = null;
        }
        if (!(virtualFile = this.getSubFile(this.sequence)).isFile()) {
            this.fis = null;
            this.islast = true;
            return false;
        }
        this.fis = new FileInputStream(virtualFile);
        ++this.sequence;
        this.voffset = 0;
        this.vsize = (int)virtualFile.length();
        if (this.vsize < this.filesizeLimit) {
            this.islast = true;
            if (!$assertionsDisabled && this.vsize > this.filesizeLimit) {
                throw new AssertionError((Object)(String.valueOf(this.vsize) + "," + this.filesizeLimit));
            }
        }
        return true;
    }

    public void close() throws IOException {
        if (this.fis != null) {
            this.fis.close();
            this.fis = null;
        }
    }

    public int fillBuffer() throws IOException {
        int readcnt = 0;
        int left = this.buffer.length;
        while (left > 0) {
            if (this.voffset == this.vsize && !this.getNextFile()) {
                if (readcnt != 0) break;
                return -1;
            }
            int rsize = Math.min(left, this.vsize - this.voffset);
            int cnt = this.fis.read(this.buffer, readcnt, rsize);
            this.voffset += cnt;
            readcnt += cnt;
            left -= cnt;
        }
        this.bsize = readcnt;
        this.boffset = 0;
        return this.bsize;
    }

    public final int read() throws IOException {
        int readcnt;
        if (this.boffset >= this.bsize && (readcnt = this.fillBuffer()) == -1) {
            throw new IOException("Arrived at EOF.");
        }
        return this.buffer[this.boffset++] & 0xFF;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int readcnt = 0;
        int left = len;
        while (left > 0) {
            if (this.boffset >= this.bsize && this.fillBuffer() == -1) break;
            int rsize = Math.min(left, this.bsize - this.boffset);
            System.arraycopy(this.buffer, this.boffset, b, off + readcnt, rsize);
            readcnt += rsize;
            this.boffset += rsize;
            left -= rsize;
        }
        return readcnt;
    }
}

