/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;

public class VirtualFileOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    protected FileOutputStream fout;
    protected int position;
    protected int sequence;
    private static final int INITIAL_BUFFER_SIZE = 4096;
    private static final int INITIAL_FILESIZE_LIMIT = 0x40000000;
    private String basePrefix;
    private int filesizeLimit;

    public VirtualFileOutputStream(String name) throws IOException {
        this(name, false, 0x40000000, 4096);
    }

    public VirtualFileOutputStream(String name, boolean append) throws IOException {
        this(name, append, 0x40000000, 4096);
    }

    public VirtualFileOutputStream(String name, boolean append, int filesizeLimit, int bufferSize) throws IOException {
        if (bufferSize < 16) {
            throw new IllegalArgumentException("Illegal buffer size(cannot be smaller than 16) : " + bufferSize);
        }
        this.basePrefix = name;
        this.filesizeLimit = filesizeLimit;
        this.buf = new byte[bufferSize];
        this.count = 0;
        if (append) {
            this.setAppendFileAndPosition();
            this.removeOldFiles(this.sequence + 1);
        } else {
            this.removeOldFiles(0);
            this.sequence = 0;
            this.fout = new FileOutputStream(this.getFileName(this.sequence), false);
        }
    }

    public String getPrefixName() {
        return this.basePrefix;
    }

    private void setAppendFileAndPosition() throws IOException {
        this.sequence = 0;
        while (true) {
            File f;
            if (!(f = new File(this.getFileName(this.sequence))).exists()) {
                this.fout = new FileOutputStream(f, false);
                this.position = 0;
                break;
            }
            if (!f.isFile()) {
                throw new IOException("Directory cannot be a sub-file : " + f.getAbsolutePath());
            }
            if (f.length() != (long)this.filesizeLimit) {
                this.fout = new FileOutputStream(f, true);
                this.position = (int)f.length();
                break;
            }
            ++this.sequence;
        }
    }

    private void removeOldFiles(int from) throws IOException {
        File parent = this.getSubFile(0).getAbsoluteFile().getParentFile();
        String prefix = new File(this.basePrefix).getName();
        SubFilenameFilter filter = new SubFilenameFilter(prefix, from);
        if (parent != null) {
            File[] files = parent.listFiles(filter);
            int i = 0;
            while (i < files.length) {
                if (!files[i].delete()) {
                    throw new IOException("Cannot delete sub-file : " + files[i].getAbsolutePath());
                }
                ++i;
            }
        }
    }

    private File getSubFile(int seq) {
        return new File(this.getFileName(seq));
    }

    private String getFileName(int seq) {
        if (seq == 0) {
            return this.basePrefix;
        }
        return String.valueOf(this.basePrefix) + "." + seq;
    }

    private void closeAndAdvanceToNextFile() throws IOException {
        this.fout.close();
        ++this.sequence;
        this.fout = new FileOutputStream(this.getFileName(this.sequence), false);
        this.position = 0;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            if (this.position + this.count > this.filesizeLimit) {
                int size = this.filesizeLimit - this.position;
                if (size > 0) {
                    this.fout.write(this.buf, 0, size);
                }
                this.closeAndAdvanceToNextFile();
                if (this.count - size > 0) {
                    this.fout.write(this.buf, size, this.count - size);
                    this.position += this.count - size;
                }
            } else {
                this.fout.write(this.buf, 0, this.count);
                this.position += this.count;
            }
            this.count = 0;
        }
    }

    public final void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        int left = len;
        while (left > 0) {
            int size = Math.min(this.buf.length - this.count, left);
            System.arraycopy(b, off, this.buf, this.count, size);
            this.count += size;
            off += size;
            left -= size;
            if (this.count != this.buf.length) continue;
            this.flushBuffer();
        }
    }

    public void write(char[] c, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            this.write(c[off + i] >>> 8);
            this.write(c[off + i] & 0xFF);
            ++i;
        }
    }

    public void flush() throws IOException {
        this.flushBuffer();
        this.fout.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.fout.close();
    }

    public long position() {
        return (long)this.sequence * (long)this.filesizeLimit + (long)this.position + (long)this.count;
    }

    public int getSequence() {
        return this.sequence;
    }

    private static class SubFilenameFilter
    implements FilenameFilter {
        private final String originalFilename;
        private final String filenamePrefix;
        final int filenamePrefixLength;
        final int from;

        public SubFilenameFilter(String prefix, int from) {
            this.originalFilename = prefix;
            this.filenamePrefix = String.valueOf(prefix) + ".";
            this.filenamePrefixLength = this.filenamePrefix.length();
            this.from = from;
        }

        public boolean accept(File dir, String name) {
            if (name.equals(this.originalFilename)) {
                return this.from <= 0;
            }
            if (name.startsWith(this.filenamePrefix)) {
                name = name.substring(this.filenamePrefixLength);
                try {
                    int num = Integer.parseInt(name);
                    if (num >= this.from) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

