/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class VirtualRandomAccessFile {
    private static final int INITIAL_FILESIZE_LIMIT = 0x40000000;
    private final String basePrefix;
    private final int subfileSize;
    private long position;
    private int nSequence = 0;
    private FileChannel[] fc;
    private RandomAccessFile[] raf;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.io.VirtualRandomAccessFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public VirtualRandomAccessFile(String name, boolean create) throws IOException {
        this(name, create, 0x40000000);
    }

    public VirtualRandomAccessFile(String name, boolean create, int filesizeLimit) throws IOException {
        this.basePrefix = name;
        this.subfileSize = filesizeLimit;
        this.raf = new RandomAccessFile[1];
        this.fc = new FileChannel[1];
        if (create) {
            this.removeOldFiles(0);
            this.nSequence = 0;
            this.openNextFile();
        } else {
            this.openAllFiles();
            this.removeOldFiles(this.nSequence);
        }
        this.position = 0L;
    }

    public String getPrefixName() {
        return this.basePrefix;
    }

    private File getSubFile(int seq) {
        if (seq == 0) {
            return new File(this.basePrefix);
        }
        return new File(String.valueOf(this.basePrefix) + "." + seq);
    }

    private static File getSubFile(String prefix, int seq) {
        if (seq == 0) {
            return new File(prefix);
        }
        return new File(String.valueOf(prefix) + "." + seq);
    }

    private void openAllFiles() throws IOException {
        File f;
        this.nSequence = 0;
        while ((f = this.getSubFile(this.nSequence)).exists()) {
            if (!f.isFile()) {
                throw new IOException("Directory cannot be a sub-file : " + f.getAbsolutePath());
            }
            if (f.length() < (long)this.subfileSize) break;
            if (f.length() > (long)this.subfileSize) {
                throw new IOException("Illegal sub-file size : " + f.getAbsolutePath());
            }
            this.openNextFile();
        }
        this.openNextFile();
    }

    private void openNextFile() throws FileNotFoundException {
        if (this.nSequence >= this.raf.length) {
            RandomAccessFile[] newRaf = new RandomAccessFile[this.nSequence + 1];
            System.arraycopy(this.raf, 0, newRaf, 0, this.nSequence);
            this.raf = newRaf;
            FileChannel[] newFc = new FileChannel[this.nSequence + 1];
            System.arraycopy(this.fc, 0, newFc, 0, this.nSequence);
            this.fc = newFc;
        }
        this.raf[this.nSequence] = new RandomAccessFile(this.getSubFile(this.nSequence), "rw");
        this.fc[this.nSequence] = this.raf[this.nSequence].getChannel();
        ++this.nSequence;
    }

    private void removeOldFiles(int from) throws IOException {
        VirtualRandomAccessFile.removeSubFiles(this.basePrefix, from);
    }

    public static void removeSubFiles(String basePrefix, int from) throws IOException {
        File[] files;
        File parent = VirtualRandomAccessFile.getSubFile(basePrefix, 0).getAbsoluteFile().getParentFile();
        String prefix = new File(basePrefix).getName();
        SubFilenameFilter filter = new SubFilenameFilter(prefix, from);
        if (parent != null && (files = parent.listFiles(filter)) != null) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].delete()) {
                    throw new IOException("Cannot delete sub-file : " + files[i].getAbsolutePath());
                }
                ++i;
            }
        }
    }

    public final long getTotalSize() throws IOException {
        return (long)(this.nSequence - 1) * (long)this.subfileSize + this.fc[this.nSequence - 1].size();
    }

    public final long position() {
        return this.position;
    }

    public final void position(long pos) {
        if (!$assertionsDisabled && pos < 0L) {
            throw new AssertionError();
        }
        this.position = pos;
    }

    public final void truncate(long pos) throws IOException {
        long size = this.getTotalSize();
        if (pos >= size) {
            return;
        }
        int sequence = (int)(pos / (long)this.subfileSize);
        int offset = (int)(pos % (long)this.subfileSize);
        int i = sequence + 1;
        while (i < this.nSequence) {
            this.raf[i].close();
            this.fc[i] = null;
            this.raf[i] = null;
            boolean deleted = this.getSubFile(i).delete();
            if (!deleted) {
                System.out.println("WARN : file[" + this.getSubFile(i).getAbsolutePath() + "] is not deleted");
            }
            ++i;
        }
        this.nSequence = sequence + 1;
        this.fc[sequence].truncate(offset);
    }

    public final int read(ByteBuffer buffer) throws IOException {
        int read;
        int sequence = (int)(this.position / (long)this.subfileSize);
        int offset = (int)(this.position % (long)this.subfileSize);
        int bSize = buffer.remaining();
        if (sequence >= this.nSequence) {
            throw new EOFException("Arrived at EOF.");
        }
        if (bSize <= this.subfileSize - offset) {
            read = this.fc[sequence].read(buffer, offset);
        } else {
            int chunkSize = this.subfileSize - offset;
            int oldLimit = buffer.limit();
            buffer.limit(buffer.position() + chunkSize);
            read = this.fc[sequence].read(buffer, offset);
            if (read == chunkSize && ++sequence < this.nSequence) {
                buffer.limit(oldLimit);
                int read2 = this.fc[sequence].read(buffer, 0L);
                if (read2 > 0) {
                    read += read2;
                }
            }
        }
        if (read > 0) {
            this.position += (long)read;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(ByteBuffer.wrap(b, off, len));
    }

    public int read(byte[] b) throws IOException {
        return this.read(ByteBuffer.wrap(b));
    }

    public final int write(ByteBuffer buffer) throws IOException {
        int wrote;
        int sequence = (int)(this.position / (long)this.subfileSize);
        int offset = (int)(this.position % (long)this.subfileSize);
        int bSize = buffer.remaining();
        if (sequence >= this.nSequence) {
            while (this.nSequence <= sequence) {
                this.openNextFile();
            }
        }
        if (bSize <= this.subfileSize - offset) {
            wrote = this.fc[sequence].write(buffer, offset);
        } else {
            int chunkSize = this.subfileSize - offset;
            int oldLimit = buffer.limit();
            buffer.limit(buffer.position() + chunkSize);
            wrote = this.fc[sequence].write(buffer, offset);
            if (wrote == chunkSize) {
                if (this.nSequence == ++sequence) {
                    this.openNextFile();
                }
                buffer.limit(oldLimit);
                wrote += this.fc[sequence].write(buffer, 0L);
            }
        }
        this.position += (long)wrote;
        return wrote;
    }

    public int write(byte[] b, int off, int len) throws IOException {
        return this.write(ByteBuffer.wrap(b, off, len));
    }

    public int write(byte[] b) throws IOException {
        return this.write(ByteBuffer.wrap(b));
    }

    public final void close() throws IOException {
        int i = 0;
        while (i < this.nSequence) {
            this.raf[i].close();
            this.fc[i] = null;
            this.raf[i] = null;
            ++i;
        }
        this.nSequence = 0;
    }

    public void clear() throws IOException {
        this.close();
        this.raf = new RandomAccessFile[1];
        this.fc = new FileChannel[1];
        this.removeOldFiles(0);
        this.nSequence = 0;
        this.openNextFile();
    }

    private static class SubFilenameFilter
    implements FilenameFilter {
        private final String originalFilename;
        private final String filenamePrefix;
        final int filenamePrefixLength;
        final int from;

        public SubFilenameFilter(String prefix, int from) {
            this.originalFilename = prefix;
            this.filenamePrefix = String.valueOf(prefix) + ".";
            this.filenamePrefixLength = this.filenamePrefix.length();
            this.from = from;
        }

        public boolean accept(File dir, String name) {
            if (name.equals(this.originalFilename)) {
                return this.from <= 0;
            }
            if (name.startsWith(this.filenamePrefix)) {
                name = name.substring(this.filenamePrefixLength);
                try {
                    int num = Integer.parseInt(name);
                    if (num >= this.from) {
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

