/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.log;

import com.diquest.ir.util.common.TraverseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    static SimpleDateFormat formatter = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss", Locale.KOREA);
    private final boolean bracket;

    public LogFormatter(boolean bracket) {
        this.bracket = bracket;
    }

    public String format(LogRecord rec) {
        StringBuffer buf = new StringBuffer(1000);
        Date currentTime = new Date();
        buf.append(formatter.format(currentTime));
        if ("".equals(rec.getSourceClassName()) && "".equals(rec.getSourceMethodName())) {
            buf.append("," + rec.getLevel() + "]");
        } else {
            buf.append("," + rec.getSourceClassName() + "," + rec.getSourceMethodName() + "," + rec.getLevel() + "]");
        }
        buf.append(this.formatMessage(rec));
        if (this.bracket) {
            buf.append('\n');
        }
        if (rec.getLevel().intValue() == Level.SEVERE.intValue()) {
            if (this.bracket) {
                buf.append('\n');
                buf.append(" -->");
                buf.append('\n');
            }
            if (rec.getThrown() != null) {
                buf.append(new TraverseException(rec.getThrown()).chain());
            }
            if (this.bracket) {
                buf.append(" <--");
            }
        }
        return buf.toString();
    }

    public String getHead(Handler h) {
        return "";
    }

    public String getTail(Handler h) {
        return "";
    }
}

