/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.log;

import com.diquest.ir.util.common.CalendarUtil;
import com.diquest.ir.util.common.IrProperties;
import com.diquest.ir.util.log.LogCollections;
import com.diquest.ir.util.log.LogFormatter;
import java.io.File;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class Logger {
    private static final int DAY_IN_MILLIS = 86400000;
    public java.util.logging.Logger logger;
    private final String root;
    private final int max;
    public int yyyymmdd;
    private final LogCollections collections;
    private final boolean console;
    private final boolean bracket;
    private Date start;
    private long period;
    private String component;
    private String business;
    Timer timer = null;
    LogTimerTask timerTask = null;

    public String getName() {
        return this.collections.filter.component;
    }

    public Logger(LogCollections collections, String root, boolean console, boolean bracket, int max) throws IOException {
        this(collections, root, console, bracket, max, null, 0L);
    }

    public Logger(LogCollections collections, String root, boolean console, boolean bracket, int max, Date start, long period) throws IOException {
        this.collections = collections;
        this.root = root;
        this.yyyymmdd = CalendarUtil.parseInt(Calendar.getInstance(), CalendarUtil.YYYYMMDD_FORMAT);
        this.console = console;
        this.bracket = bracket;
        this.component = "";
        this.business = "";
        this.max = max;
        this.start = start;
        this.period = period;
        this.logger = java.util.logging.Logger.getLogger(collections.filter.component);
        File rootdir = new File(root);
        if (!rootdir.isDirectory()) {
            rootdir.mkdirs();
        }
        if (!this.appendable(new File(this.nomeFile(-1)))) {
            this.rolling();
        }
        this.addHandler();
        this.logger.setLevel(Level.ALL);
    }

    public void cancelRolling() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void schedule(Date start, long period) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        if (start == null) {
            this.start = this.midnight();
        }
        if (period == 0L) {
            this.period = 86400000L;
        }
        this.timerTask = new LogTimerTask();
        this.timer.scheduleAtFixedRate((TimerTask)this.timerTask, this.start, this.period);
    }

    public void schedule() {
        this.schedule(this.start, this.period);
    }

    public Date midnight() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public void entering(String component, String business) {
        this.component = component;
        this.business = business;
    }

    private void addHandler() throws IOException {
        FileHandler fh = new FileHandler(this.nomeFile(-1), true);
        this.logger.setUseParentHandlers(false);
        LogFormatter fmt = new LogFormatter(this.bracket);
        fh.setFormatter(fmt);
        fh.setEncoding(IrProperties.ENCODING);
        this.logger.addHandler(fh);
        if (this.console) {
            ConsoleHandler ch = new ConsoleHandler();
            ch.setFormatter(fmt);
            this.logger.addHandler(ch);
        }
    }

    private void removeHandler() {
        Handler[] handlers = this.logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            handlers[i].close();
            this.logger.removeHandler(handlers[i]);
            ++i;
        }
    }

    private boolean appendable(File base) {
        if (base.exists()) {
            Calendar last = Calendar.getInstance();
            Calendar current = Calendar.getInstance();
            Date lastmodified = new Date(base.lastModified());
            last.setTime(lastmodified);
            int last_yymmdd = CalendarUtil.parseInt(last, "yyyymmdd");
            int current_yymmdd = CalendarUtil.parseInt(current, "yyyymmdd");
            return last_yymmdd == current_yymmdd;
        }
        return true;
    }

    public boolean appendable() {
        return this.appendable(new File(this.nomeFile(-1)));
    }

    private boolean splitable() {
        return this.yyyymmdd < CalendarUtil.parseInt(Calendar.getInstance(), CalendarUtil.YYYYMMDD_FORMAT);
    }

    public void splite() throws IOException {
        if (this.splitable()) {
            this.rolling();
        }
    }

    public void rolling() throws IOException {
        this.removeHandler();
        File dir = new File(this.root);
        File[] logfiles = dir.listFiles(this.collections.filter);
        this.collections.sort(logfiles);
        int i = 0;
        while (i < logfiles.length) {
            File logFile = logfiles[i];
            File toFile = null;
            int sequence = this.collections.comparator.sequence.parse(logFile);
            int nextSeq = -1;
            if (sequence > -1) {
                boolean deleted;
                nextSeq = sequence + 1;
                if (!(this.max >= nextSeq && nextSeq >= 0 || (deleted = logFile.delete()))) {
                    throw new IOException("Cannot delete file : " + logFile.getAbsolutePath());
                }
                toFile = new File(this.nomeFile(nextSeq));
            } else {
                toFile = new File(this.nomeFile(1));
            }
            if (logFile.exists()) {
                logFile.renameTo(toFile);
            }
            ++i;
        }
        this.addHandler();
    }

    public void setLastModified(long time) {
        File file = new File(this.nomeFile(-1));
        file.setLastModified(time);
    }

    private String nomeFile(int seq) {
        if (seq == -1) {
            return String.valueOf(this.root) + "/" + this.collections.filter.component + ".log";
        }
        return String.valueOf(this.root) + "/" + this.collections.filter.component + "." + seq;
    }

    public void log(String msg, Level level) {
        this.logger.logp(level, this.component, this.business, msg);
    }

    public void log(String msg, Level level, Throwable e) {
        this.logger.logp(level, this.component, this.business, msg, e);
    }

    public void warn(String msg) {
        this.log(msg, Level.WARNING);
    }

    public void severe(String msg) {
        this.log(msg, Level.SEVERE);
    }

    public void info(String msg) {
        this.log(msg, Level.INFO);
    }

    public void severe(String msg, Throwable e) {
        this.log(msg, Level.SEVERE, e);
    }

    public void close() {
        this.removeHandler();
    }

    public void stop() {
        this.cancelRolling();
        this.close();
    }

    class LogTimerTask
    extends TimerTask {
        LogTimerTask() {
        }

        public void run() {
            try {
                Logger.this.rolling();
            }
            catch (IOException e) {
                Logger.this.severe(e.getMessage(), e);
            }
        }
    }
}

