/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.msg;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.type.ArrayT;
import com.diquest.ir.util.msg.type.BooleanT;
import com.diquest.ir.util.msg.type.ByteT;
import com.diquest.ir.util.msg.type.CharT;
import com.diquest.ir.util.msg.type.DataT;
import com.diquest.ir.util.msg.type.IntegerT;
import com.diquest.ir.util.msg.type.ListT;
import com.diquest.ir.util.msg.type.LongT;
import com.diquest.ir.util.msg.type.MapT;
import com.diquest.ir.util.msg.type.SerializableT;
import com.diquest.ir.util.msg.type.ShortT;
import com.diquest.ir.util.msg.type.StringT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Message
extends Transmitable {
    public Transmitable[] values;

    protected Message() {
    }

    public Message(int size) {
        this.values = new Transmitable[size];
    }

    public final void set(int pos, Transmitable v) {
        this.values[pos] = v;
    }

    public final void setInt(int pos, int v) {
        this.set(pos, new IntegerT(v));
    }

    public final void setLong(int pos, long v) {
        this.set(pos, new LongT(v));
    }

    public final void setShort(int pos, short v) {
        this.set(pos, new ShortT(v));
    }

    public final void setByte(int pos, byte v) {
        this.set(pos, new ByteT(v));
    }

    public final void setChar(int pos, char v) {
        this.set(pos, new CharT(v));
    }

    public final void setBoolean(int pos, boolean v) {
        this.set(pos, new BooleanT(v));
    }

    public final void setString(int pos, String v) {
        this.set(pos, new StringT(v));
    }

    public final void setArray(int pos, Transmitable[] v) {
        this.set(pos, new ArrayT(v));
    }

    public final void setList(int pos, List v) {
        this.set(pos, new ListT(v));
    }

    public final void setMap(int pos, Map v) {
        this.set(pos, new MapT(v));
    }

    public final void setData(int pos, Map v) {
        this.set(pos, new DataT(v));
    }

    public final void setData(int pos, DataT v) {
        this.set(pos, v);
    }

    public final void setSerializable(int pos, Serializable v) {
        this.values[pos] = new SerializableT(v);
    }

    public final Transmitable get(int pos) {
        if (pos < this.values.length) {
            return this.values[pos];
        }
        return null;
    }

    public final int getInt(int pos) {
        if (this.values[pos] instanceof IntegerT) {
            return ((IntegerT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a IntegerT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final long getLong(int pos) {
        if (this.values[pos] instanceof LongT) {
            return ((LongT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a LongT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final short getShort(int pos) {
        if (this.values[pos] instanceof ShortT) {
            return ((ShortT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a ShortT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final byte getByte(int pos) {
        if (this.values[pos] instanceof ByteT) {
            return ((ByteT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a ByteT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final char getChar(int pos) {
        if (this.values[pos] instanceof CharT) {
            return ((CharT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a CharT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final boolean getBoolean(int pos) {
        if (this.values[pos] instanceof BooleanT) {
            return ((BooleanT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a BooleanT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final String getString(int pos) {
        if (this.values[pos] instanceof StringT) {
            return ((StringT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a StringT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final List getList(int pos) {
        if (this.values[pos] instanceof ListT) {
            return ((ListT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a ListT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final Transmitable[] getArray(int pos) {
        if (this.values[pos] instanceof ArrayT) {
            return ((ArrayT)this.values[pos]).value;
        }
        throw new IllegalArgumentException("Not a ArrayT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final Map getMap(int pos) {
        if (this.values[pos] instanceof MapT) {
            return ((MapT)this.values[pos]).value_;
        }
        throw new IllegalArgumentException("Not a MapT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public final Serializable getSerializable(int pos) {
        if (this.values[pos] == null) {
            return null;
        }
        if (this.values[pos] instanceof SerializableT) {
            return ((SerializableT)this.values[pos]).getValue();
        }
        throw new IllegalArgumentException("Not a SerializableT : " + pos + "th value of " + this.getClass().getName() + " : " + this.values[pos].getClass().getName());
    }

    public void serialize(OutputStream out) throws IOException {
        int length = this.values.length;
        ByteUtil.writeInt(out, this.values.length);
        int i = 0;
        while (i < length) {
            Transmitable.writeTo(this.values[i], out);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        int length = ByteUtil.readInt(in);
        this.values = new Transmitable[length];
        int i = 0;
        while (i < length) {
            this.values[i] = Transmitable.readFrom(in);
            ++i;
        }
    }

    public boolean isNull() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[Message] :");
        buffer.append(" size = ");
        buffer.append(this.values.length);
        int i = 0;
        while (i <= this.values.length - 1) {
            buffer.append(", " + i + "th value : ");
            buffer.append(this.get(i));
            ++i;
        }
        return buffer.toString();
    }

    public Transmitable getInstance() {
        return new Message();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Message castedObj = (Message)o;
        return Arrays.equals(this.values, castedObj.values);
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        int i0 = 0;
        while (this.values != null && i0 < this.values.length) {
            hashCode = 31 * hashCode + (this.values == null ? 0 : this.values[i0].hashCode());
            ++i0;
        }
        return hashCode;
    }

    public int size() {
        return this.values != null ? this.values.length : 0;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

