/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.msg;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.TransmitableKnownFactory;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Hashtable;

public abstract class Transmitable {
    public static final int VALUE_NULL = 0;
    public static final int VALUE_WITH_NAME = 1;
    public static final int VALUE_KNOWN_START = 2;
    private static Hashtable factories;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.msg.Transmitable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        factories = new Hashtable();
    }

    public static final void writeTo(Transmitable object, OutputStream out) throws IOException {
        if (object == null || object.isNull()) {
            out.write(0);
            return;
        }
        if (object.typecode() < 0) {
            out.write(1);
            ByteUtil.writeString(out, object.getClass().getName());
        } else {
            out.write(2 + object.typecode());
        }
        object.serialize(out);
    }

    public final void writeTo(OutputStream out) throws IOException {
        if (this.isNull()) {
            out.write(0);
            return;
        }
        if (this.typecode() < 0) {
            out.write(1);
            ByteUtil.writeString(out, this.getClass().getName());
        } else {
            out.write(2 + this.typecode());
        }
        this.serialize(out);
    }

    public static final Transmitable readFrom(InputStream in) throws IOException {
        int type = in.read();
        if (type == -1) {
            throw new EOFException("Cannot read data, reach to the end of input.");
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                String name = ByteUtil.readString(in);
                Transmitable f1 = (Transmitable)factories.get(name);
                if (f1 == null) {
                    try {
                        Class<?> c = Class.forName(name);
                        f1 = (Transmitable)c.newInstance();
                        factories.put(name, f1);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (InstantiationException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (ClassCastException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                Transmitable f2 = f1.getInstance();
                f2.deserialize(in);
                return f2;
            }
        }
        return Transmitable.reconstructKnownType(in, type);
    }

    public static final Transmitable readFrom(InputStream in, String explicitName) throws IOException {
        int type = in.read();
        if (type == -1) {
            throw new EOFException("Cannot read data, reach to the end of input.");
        }
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                String name = ByteUtil.readString(in);
                name = explicitName;
                Transmitable f1 = (Transmitable)factories.get(name);
                if (f1 == null) {
                    try {
                        Class<?> c = Class.forName(name);
                        f1 = (Transmitable)c.newInstance();
                        factories.put(name, f1);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (InstantiationException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (IllegalAccessException e) {
                        throw new IOException(e.getMessage());
                    }
                    catch (ClassCastException e) {
                        throw new IOException(e.getMessage());
                    }
                }
                Transmitable f2 = f1.getInstance();
                f2.deserialize(in);
                return f2;
            }
        }
        return Transmitable.reconstructKnownType(in, type);
    }

    public static final Transmitable reconstructKnownType(InputStream in, int type) throws IOException {
        Transmitable t = TransmitableKnownFactory.getKnownInstance(type -= 2);
        if (t == null) {
            throw new IOException("Unknown type of Transmitable : " + type);
        }
        t.deserialize(in);
        return t;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        Transmitable castedObj = (Transmitable)o;
        try {
            ByteArrayOutputStream out1 = new ByteArrayOutputStream();
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            this.serialize(out1);
            castedObj.serialize(out2);
            byte[] b1 = out1.toByteArray();
            byte[] b2 = out2.toByteArray();
            return Arrays.equals(b1, b2);
        }
        catch (IOException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"Cannot be happened.");
            }
            return false;
        }
    }

    public abstract boolean isNull();

    public abstract void serialize(OutputStream var1) throws IOException;

    public abstract void deserialize(InputStream var1) throws IOException;

    public abstract Transmitable getInstance();

    protected int typecode() {
        return -1;
    }
}

