/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.msg.type;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.TransmitableKnownFactory;
import com.diquest.ir.util.msg.type.StringT;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class DataT
extends Transmitable {
    protected static final int typecode;
    private static final int DEFAULT_CAPACITY = 8;
    public String[] key;
    private Transmitable[] value;
    private int length;
    private int position;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.msg.type.DataT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.diquest.ir.util.msg.type.DataT");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typecode = TransmitableKnownFactory.getType(clazz2.getName());
    }

    protected int typecode() {
        return typecode;
    }

    public DataT() {
        this(8);
    }

    public DataT(int capacity) {
        if (!$assertionsDisabled && capacity <= 0) {
            throw new AssertionError(capacity);
        }
        this.length = 0;
        this.position = 0;
        this.key = new String[capacity];
        this.value = new Transmitable[capacity];
    }

    public DataT(Map m) {
        this(m.size());
        m.keySet().toArray(this.key);
        int i = 0;
        while (i < this.key.length) {
            this.value[i] = (Transmitable)m.get(this.key[i]);
            ++i;
        }
        this.length = this.key.length;
    }

    public DataT(Properties m) {
        this(m.size());
        Iterator<Map.Entry<Object, Object>> entryIter = m.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<Object, Object> entry = entryIter.next();
            this.put((String)entry.getKey(), new StringT((String)entry.getValue()));
        }
        this.length = this.key.length;
    }

    public boolean isNull() {
        return false;
    }

    public List keySet() {
        ArrayList<String> keySet = new ArrayList<String>();
        int i = 0;
        while (i < this.key.length) {
            if (this.key[i] != null) {
                keySet.add(this.key[i]);
            }
            ++i;
        }
        return keySet;
    }

    public String[] keyList() {
        return this.key;
    }

    private void ensureCapacity() {
        if (this.length >= this.key.length) {
            String[] newKey = new String[this.length * 2];
            System.arraycopy(this.key, 0, newKey, 0, this.length);
            this.key = newKey;
            Transmitable[] newValue = new Transmitable[this.length * 2];
            System.arraycopy(this.value, 0, newValue, 0, this.length);
            this.value = newValue;
        }
    }

    public void put(String key, Transmitable value) {
        this.ensureCapacity();
        this.key[this.length] = key;
        this.value[this.length] = value;
        ++this.length;
    }

    public Transmitable get(String k) {
        if (this.position > this.length) {
            this.position = 0;
        }
        int i = 0;
        while (i < this.length) {
            if (this.key[this.position].equals(k)) {
                Transmitable v = this.value[this.position];
                this.position = (this.position + 1) % this.length;
                return v;
            }
            this.position = (this.position + 1) % this.length;
            ++i;
        }
        return null;
    }

    private void writeString(OutputStream out, String value) throws IOException {
        int length = value.length();
        ByteUtil.writeVbInt(out, length);
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            out.write((c & 0xFF00) >>> 8);
            out.write((c & 0xFF) >>> 0);
            ++i;
        }
    }

    private String readString(InputStream in) throws IOException {
        int length = ByteUtil.readVbInt(in);
        char[] array = new char[length];
        int i = 0;
        while (i < length) {
            array[i] = (char)((in.read() << 8) + (in.read() << 0));
            ++i;
        }
        return new String(array);
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeVbInt(out, this.length);
        int i = 0;
        while (i < this.length) {
            this.writeString(out, this.key[i]);
            Transmitable.writeTo(this.value[i], out);
            ++i;
        }
    }

    public void deserialize(InputStream in) throws IOException {
        int inSize = ByteUtil.readVbInt(in);
        int i = 0;
        while (i < inSize) {
            String key = this.readString(in);
            Transmitable value = Transmitable.readFrom(in);
            this.put(key, value);
            ++i;
        }
    }

    public Transmitable getInstance() {
        return new DataT();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : 1111 + this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        DataT castedObj = (DataT)o;
        if (this.length != castedObj.length) {
            return false;
        }
        int i = 0;
        while (i < this.length) {
            Transmitable v = castedObj.get(this.key[i]);
            if (v != null || this.value[i] != null) {
                if (v == null || this.value[i] == null) {
                    return false;
                }
                if (!this.value[i].equals(v)) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    public int length() {
        return this.length;
    }
}

