/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.msg.type;

import com.diquest.commons.type.ByteUtil;
import com.diquest.ir.util.msg.Transmitable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class SerializableT
extends Transmitable {
    private static final int IS_NOT_NULL = 1;
    private static final int IS_NULL = 0;
    private Serializable value;

    public SerializableT() {
    }

    public SerializableT(Serializable value) {
        this.value = value;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void deserialize(InputStream in) throws IOException {
        block9: {
            int flag = in.read();
            if (flag == 0) {
                this.value = null;
            } else {
                if (flag == 1) {
                    byte[] bytes = ByteUtil.readBytes((InputStream)in);
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    try {
                        try {
                            this.value = (Serializable)ois.readObject();
                            break block9;
                        }
                        catch (ClassNotFoundException e) {
                            this.value = null;
                            throw new IOException("");
                        }
                    }
                    finally {
                        ois.close();
                    }
                }
                if (flag == -1) {
                    throw new EOFException();
                }
                throw new IOException("Unexpected value: " + flag);
            }
        }
    }

    public Transmitable getInstance() {
        return new SerializableT();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        if (this.value == null) {
            out.write(0);
        } else {
            out.write(1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this.value);
            }
            finally {
                oos.close();
            }
            ByteUtil.writeBytes((OutputStream)out, (byte[])baos.toByteArray());
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

