/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.msg.type;

import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class ThrowableT
extends Transmitable {
    private Throwable th;

    public ThrowableT(Throwable th) {
        this.th = th;
    }

    public ThrowableT() {
        this(null);
    }

    public Throwable getThrowable() {
        return this.th;
    }

    public void deserialize(InputStream in) throws IOException {
        ObjectInputStream objectInputStream = new ObjectInputStream(in);
        try {
            boolean notNull = objectInputStream.readBoolean();
            this.th = notNull ? (Throwable)objectInputStream.readObject() : null;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Transmitable getInstance() {
        return new ThrowableT();
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
        objectOutputStream.writeBoolean(this.th != null);
        if (this.th != null) {
            objectOutputStream.writeObject(this.th);
        }
        objectOutputStream.flush();
    }

    public String toString() {
        return String.valueOf(this.th);
    }

    public static ThrowableT[] convert(Transmitable[] trs) {
        ThrowableT[] thts = new ThrowableT[trs.length];
        int i = 0;
        while (i < trs.length) {
            thts[i] = (ThrowableT)trs[i];
            ++i;
        }
        return thts;
    }

    public static ThrowableT[] convert(Throwable[] ths) {
        ThrowableT[] thts = new ThrowableT[ths.length];
        int i = 0;
        while (i < ths.length) {
            thts[i] = new ThrowableT(ths[i]);
            ++i;
        }
        return thts;
    }

    public static Throwable[] convert(ThrowableT[] ths) {
        Throwable[] thts = new Throwable[ths.length];
        int i = 0;
        while (i < ths.length) {
            thts[i] = ths[i] != null ? ths[i].th : null;
            ++i;
        }
        return thts;
    }
}

