/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.msg.type;

import com.diquest.ir.util.common.ByteUtil;
import com.diquest.ir.util.common.IrProperties;
import com.diquest.ir.util.common.TraverseException;
import com.diquest.ir.util.msg.Transmitable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class XmlT
extends Transmitable {
    private Object settingObject;
    private String packageName;

    public XmlT() {
    }

    public XmlT(Object settingObject, String packageName) {
        this.settingObject = settingObject;
        this.packageName = packageName;
    }

    public boolean isNull() {
        return false;
    }

    public void serialize(OutputStream out) throws IOException {
        ByteUtil.writeString(out, this.packageName);
        ByteUtil.writeBoolean(out, this.settingObject != null);
        if (this.settingObject != null) {
            try {
                JAXBContext jc = JAXBContext.newInstance((String)this.packageName);
                Marshaller marshaller = jc.createMarshaller();
                marshaller.setProperty("jaxb.encoding", (Object)IrProperties.IANA_ENCODING);
                marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                ByteArrayOutputStream workspace = new ByteArrayOutputStream();
                marshaller.marshal(this.settingObject, (OutputStream)workspace);
                ByteUtil.writeBytes(out, workspace.toByteArray());
            }
            catch (JAXBException e) {
                e.printStackTrace();
                TraverseException tr = new TraverseException(e);
                throw new IOException(tr.chainMessage());
            }
        }
    }

    public void deserialize(InputStream in) throws IOException {
        this.packageName = ByteUtil.readString(in);
        if (ByteUtil.readBoolean(in)) {
            try {
                JAXBContext jc = JAXBContext.newInstance((String)this.packageName);
                Unmarshaller u = jc.createUnmarshaller();
                ByteArrayInputStream workspace = new ByteArrayInputStream(ByteUtil.readBytes(in));
                this.settingObject = u.unmarshal((InputStream)workspace);
            }
            catch (JAXBException e) {
                e.printStackTrace();
                TraverseException tr = new TraverseException(e);
                throw new IOException(tr.chainMessage());
            }
        } else {
            this.settingObject = null;
        }
    }

    public Object getSettingObject() {
        return this.settingObject;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Transmitable getInstance() {
        return new XmlT();
    }
}

