/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.network;

import com.diquest.ir.util.common.VectorUtil;
import com.diquest.ir.util.io.FastByteArrayInputStream;
import com.diquest.ir.util.io.FastByteArrayOutputStream;
import com.diquest.ir.util.msg.Transmitable;
import java.io.IOException;
import java.io.InputStream;

public class MessageLogic {
    public static final int HEADER_SIZE = 4;
    public static final int INTEGER_SIZE = 4;
    public static final byte[] HEADER_PACKET;
    public static final byte[] START_PACKET;
    public static final byte[] CLOSE_PACKET;
    public static final int NO_HEADER = 0;
    public static final int MSG_HEADER = 1;
    public static final int START_HEADER = 2;
    public static final int CLOSE_HEADER = 3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.network.MessageLogic");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        HEADER_PACKET = new byte[]{97, 101, 99, 53};
        START_PACKET = new byte[]{100, 113, 109, 50};
        CLOSE_PACKET = new byte[]{50, 109, 113, 100};
    }

    public static int headerCheck(byte[] header) {
        if (header == null || header.length < 4) {
            return 0;
        }
        if (MessageLogic.oneHeaderCheck(header, HEADER_PACKET)) {
            return 1;
        }
        if (MessageLogic.oneHeaderCheck(header, CLOSE_PACKET)) {
            return 3;
        }
        if (MessageLogic.oneHeaderCheck(header, START_PACKET)) {
            return 2;
        }
        return 0;
    }

    private static boolean oneHeaderCheck(byte[] header, byte[] want) {
        if (!($assertionsDisabled || header.length >= 4 && want.length == 4)) {
            throw new AssertionError((Object)("header.length=" + header.length + ",want.length=" + want.length));
        }
        int i = 0;
        while (i < 4) {
            if (header[i] != want[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void makePacket(FastByteArrayOutputStream baos, Transmitable msg) throws IOException {
        int headerSize = 8;
        baos.position(headerSize);
        msg.writeTo(baos);
        byte[] array = baos.array();
        int size = baos.position();
        VectorUtil.write(array, 0, HEADER_PACKET);
        VectorUtil.writeInt(array, 4, size - headerSize);
    }

    public static void readFromSocket(InputStream in, byte[] buffer, int offset, int size) throws IOException {
        int left = size;
        while (left > 0) {
            int read = in.read(buffer, offset, left);
            if (read <= 0) {
                throw new IOException("Cannot read from socket : " + read);
            }
            left -= read;
            offset += read;
        }
    }

    public static int readPacket(FastByteArrayInputStream bais, InputStream is) throws IOException {
        byte[] buffer = bais.array;
        if (buffer == null) {
            buffer = new byte[8];
        }
        MessageLogic.readFromSocket(is, buffer, 0, 4);
        int headerType = MessageLogic.headerCheck(buffer);
        if (headerType == 1) {
            MessageLogic.readFromSocket(is, buffer, 0, 4);
            int size = VectorUtil.readInt(buffer, 0);
            if (size <= 0) {
                headerType = 0;
            } else {
                if (buffer.length < size) {
                    buffer = new byte[size];
                }
                MessageLogic.readFromSocket(is, buffer, 0, size);
                bais.init(buffer, 0, size);
            }
        }
        return headerType;
    }
}

