/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms;

import com.diquest.ir.util.rdbms.Container;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionFactory {
    private static final int DEFAULT_TIMEOUT = 30;
    protected static RdbmsProperties rdbms_properties = RdbmsPropertiesFactory.load();
    private static volatile boolean available = true;
    static /* synthetic */ Class class$0;

    public static Connection getConnection() throws SQLException {
        return ConnectionFactory.getConnection(30);
    }

    public static Connection create(String driver, RdbmsProperties db) throws SQLException {
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return ConnectionFactory.create(db);
    }

    public static synchronized Connection create(RdbmsProperties db) throws SQLException {
        return DriverManager.getConnection(db.getUrl(), db.getProperties());
    }

    public static synchronized Connection create(RdbmsProperties db, int seconds) throws SQLException {
        if (db.getUrl().indexOf("Altibase") == -1) {
            DriverManager.setLoginTimeout(seconds);
        }
        return DriverManager.getConnection(db.getUrl(), db.getProperties());
    }

    public static boolean release(ResultSet rs, Statement stmt, Connection conn) {
        try {
            block13: {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Throwable throwable) {
                        if (conn != null) {
                            conn.close();
                        }
                        throw throwable;
                    }
                    if (conn != null) {
                        conn.close();
                    }
                    break block13;
                }
                {
                }
            }
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean release(Connection conn) {
        return ConnectionFactory.release(null, null, conn);
    }

    public static boolean release(PreparedStatement pstmt, Connection conn) {
        return ConnectionFactory.release(null, pstmt, conn);
    }

    public static boolean release(PreparedStatement pstmt) {
        return ConnectionFactory.release(null, pstmt, null);
    }

    public static boolean release(ResultSet rs, PreparedStatement pstmt) {
        return ConnectionFactory.release(rs, pstmt, null);
    }

    public static boolean release(Connection conn, boolean error) {
        if (conn == null) {
            return true;
        }
        try {
            if (!conn.getAutoCommit()) {
                if (error) {
                    conn.rollback();
                } else {
                    conn.commit();
                }
                conn.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return ConnectionFactory.release(conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Connection getConnection(final int seconds) throws SQLException {
        final Object TIMEOUT = new Object();
        final Container box = new Container();
        StackTraceElement[] stackTrace = new RuntimeException().getStackTrace();
        String caller = "";
        int i = 0;
        while (i < stackTrace.length) {
            if (stackTrace[i].getClassName().indexOf("ConnectionFactory") == -1) {
                caller = stackTrace[i].getClassName();
                break;
            }
            ++i;
        }
        Thread connectingThread = new Thread("ConnectionFactory-getConnection-" + caller){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                long t = System.currentTimeMillis() + (long)(seconds * 1000);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                Class<?> clazz3 = clazz;
                synchronized (clazz) {
                    while (true) {
                        if (available) {
                            available = false;
                            // ** MonitorExit[var3_2] (shouldn't be in output)
                            break;
                        }
                        try {
                            long remain = t - System.currentTimeMillis();
                            if (remain <= 0L) {
                                // ** MonitorExit[var3_2] (shouldn't be in output)
                                return;
                            }
                            Class<?> clazz4 = class$0;
                            if (clazz4 == null) {
                                try {
                                    clazz4 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            clazz4.wait(remain);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        try {
                            Connection create = ConnectionFactory.create(rdbms_properties, seconds);
                            Container container = box;
                            synchronized (container) {
                                if (box.o == TIMEOUT) {
                                    ConnectionFactory.release(create);
                                } else {
                                    box.o = create;
                                }
                            }
                        }
                        catch (SQLException e) {
                            Container container = box;
                            synchronized (container) {
                                if (box.o == TIMEOUT) {
                                    e.printStackTrace();
                                } else {
                                    box.o = e;
                                }
                            }
                            Class<?> clazz5 = class$0;
                            if (clazz5 == null) {
                                Class<?> clazz6;
                                try {
                                    clazz6 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz5 = class$0 = clazz6;
                            }
                            Class<?> clazz7 = clazz5;
                            synchronized (clazz5) {
                                available = true;
                                Class<?> clazz8 = class$0;
                                if (clazz8 == null) {
                                    Class<?> clazz9;
                                    try {
                                        clazz9 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                    clazz8 = class$0 = clazz9;
                                }
                                clazz8.notifyAll();
                                // ** MonitorExit[var6_8] (shouldn't be in output)
                                return;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Class<?> clazz10 = class$0;
                        if (clazz10 == null) {
                            Class<?> clazz11;
                            try {
                                clazz11 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz10 = class$0 = clazz11;
                        }
                        Class<?> clazz12 = clazz10;
                        synchronized (clazz10) {
                            available = true;
                            Class<?> clazz13 = class$0;
                            if (clazz13 == null) {
                                Class<?> clazz14;
                                try {
                                    clazz14 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz13 = class$0 = clazz14;
                            }
                            clazz13.notifyAll();
                            // ** MonitorExit[var6_9] (shouldn't be in output)
                            throw throwable;
                        }
                    }
                    Class<?> clazz15 = class$0;
                    if (clazz15 == null) {
                        Class<?> clazz16;
                        try {
                            clazz16 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz15 = class$0 = clazz16;
                    }
                    Class<?> clazz17 = clazz15;
                    synchronized (clazz15) {
                        available = true;
                        Class<?> clazz18 = class$0;
                        if (clazz18 == null) {
                            Class<?> clazz19;
                            try {
                                clazz19 = Class.forName("com.diquest.ir.util.rdbms.ConnectionFactory");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz18 = class$0 = clazz19;
                        }
                        clazz18.notifyAll();
                        // ** MonitorExit[var6_10] (shouldn't be in output)
                        return;
                    }
                }
            }
        };
        connectingThread.setDaemon(true);
        connectingThread.start();
        try {
            connectingThread.join((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        connectingThread.interrupt();
        Container container = box;
        synchronized (container) {
            try {
                if (box.o == Container.NULL) {
                    throw new SQLException("Fail to connect in " + seconds + "sec");
                }
                Object object = box.o;
                if (object instanceof Connection) {
                    Connection connection = (Connection)object;
                    return connection;
                }
                if (object instanceof SQLException) {
                    throw (SQLException)object;
                }
                throw new SQLException("An unexpected object handling while server is connecting to the DBMS.");
            }
            finally {
                box.o = TIMEOUT;
            }
        }
    }
}

