/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms;

import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class ConnectionPool {
    static final RdbmsProperties PROPERTIES = RdbmsPropertiesFactory.load();
    static final boolean USE_POOL;
    static final long USER_TIMEOUT;
    static final boolean USE_CONNECTION_CHECK;
    static String TEST_QUERY_STRING;
    private static final ConnectionPool instance;
    private final IdentityHashMap map;
    private final Stack pool;
    private final LinkedList dates = new LinkedList();
    private final long timeout;
    private final Thread closer;
    private boolean started;
    private int newly;
    private int total;
    static /* synthetic */ Class class$0;

    static {
        String property = PROPERTIES.getProperty("ir.db.connection.pool");
        USE_POOL = property == null ? true : Boolean.valueOf(property);
        property = PROPERTIES.getProperty("ir.db.connection.pool.timeout");
        USER_TIMEOUT = property == null ? 3600000L : Long.parseLong(property);
        property = PROPERTIES.getProperty("ir.db.connection.pool.useConnectionCheck");
        USE_CONNECTION_CHECK = property == null ? true : Boolean.valueOf(property);
        property = PROPERTIES.getProperty("ir.db.connection.pool.testQueryString");
        TEST_QUERY_STRING = property == null ? null : property;
        instance = new ConnectionPool();
    }

    public static final ConnectionPool getInstance() {
        return instance;
    }

    protected void finalize() throws Throwable {
        this.stop();
    }

    private static void close(final Connection conn) {
        if (conn == null) {
            return;
        }
        Thread closer = new Thread("ConnectionPool-Closer"){

            public void run() {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    System.err.println("SQLException occured in ConnectionPool-Closer: " + e.getMessage());
                }
            }
        };
        closer.start();
    }

    public ConnectionPool() {
        this(USER_TIMEOUT);
    }

    public ConnectionPool(long timeout) {
        this.map = new IdentityHashMap(8);
        this.pool = new Stack();
        this.timeout = timeout;
        this.closer = new Closer();
    }

    public synchronized ConnectionPool start() {
        if (this.started) {
            return this;
        }
        this.started = true;
        this.closer.start();
        return this;
    }

    public synchronized void stop() throws InterruptedException {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.closer.interrupt();
        this.closer.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection acquire() throws SQLException {
        if (!USE_POOL) {
            return ConnectionFactory.getConnection();
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.rdbms.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.pool.isEmpty()) {
                ++this.total;
                ++this.newly;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return ConnectionFactory.getConnection();
            }
            Connection conn = (Connection)this.pool.pop();
            Date date = (Date)this.map.remove(conn);
            LinkedList linkedList = this.dates;
            synchronized (linkedList) {
                this.dates.remove(date);
            }
            if (System.currentTimeMillis() <= date.getTime() + this.timeout && this.validate(conn)) {
                ++this.total;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return conn;
            }
            ConnectionPool.close(conn);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return this.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release(Connection conn) {
        if (!USE_POOL) {
            ConnectionPool.close(conn);
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.diquest.ir.util.rdbms.ConnectionPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.validateRelease(conn) && !this.contains(conn)) {
                Date date = new Date();
                this.pool.push(conn);
                this.map.put(conn, date);
                LinkedList linkedList = this.dates;
                synchronized (linkedList) {
                    this.dates.add(date);
                    this.dates.notifyAll();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private boolean contains(Connection conn) {
        return this.pool.contains(conn);
    }

    private boolean validate(Connection conn) {
        block5: {
            block4: {
                try {
                    if (conn != null) break block4;
                    return false;
                }
                catch (SQLException e) {
                    System.out.println("[ConnectionPool][WARN] validate connection : An Exception is occurred during validation connection.");
                    ConnectionPool.close(conn);
                    return false;
                }
            }
            if (!conn.isClosed()) break block5;
            return false;
        }
        conn.getMetaData();
        conn.setAutoCommit(true);
        return !USE_CONNECTION_CHECK || this.isValidConnection(conn);
    }

    private boolean validateRelease(Connection conn) {
        block3: {
            try {
                if (conn != null) break block3;
                return false;
            }
            catch (SQLException e) {
                System.out.println("[ConnectionPool][WARN] validate connection : An Exception is occurred during validation connection.");
                ConnectionPool.close(conn);
                return false;
            }
        }
        return !conn.isClosed();
    }

    private boolean isValidConnection(Connection conn) {
        RdbmsSupporter supporter = null;
        PreparedStatement pstmt = null;
        boolean isValid = false;
        try {
            supporter = RdbmsSupporter.createRdbmsSupporter(conn);
            String validateSql = TEST_QUERY_STRING != null ? TEST_QUERY_STRING : supporter.getValidateSql();
            pstmt = conn.prepareStatement(validateSql);
            try {
                try {
                    pstmt.executeQuery();
                    isValid = true;
                }
                catch (SQLException e) {
                    System.out.println("[ConnectionPool][WARN] validate connection : An Exception is occured during execution of validation query.");
                    isValid = false;
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
        }
        catch (SQLException e) {
            System.out.println("[ConnectionPool][WARN] validate connection : An Exception is occured during execution of validation query.");
            isValid = false;
        }
        return isValid;
    }

    public synchronized String toString() {
        String TAB = ", ";
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append("map=");
        sb.append(this.map);
        sb.append(", ");
        sb.append("pool=");
        sb.append(this.pool);
        sb.append(", ");
        sb.append("dates=");
        sb.append(this.dates);
        sb.append(", ");
        sb.append("timeout=");
        sb.append(this.timeout);
        sb.append(", ");
        sb.append("closer=");
        sb.append(this.closer);
        sb.append(", ");
        sb.append("started=");
        sb.append(this.started);
        sb.append(", ");
        sb.append("newly=");
        sb.append(this.newly);
        sb.append(", ");
        sb.append("total=");
        sb.append(this.total);
        sb.append("]");
        return sb.toString();
    }

    class Closer
    extends Thread {
        public Closer() {
            this.setName("ConnectionPool-Closer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Class<?> clazz;
            block19: while (!Thread.interrupted()) {
                try {
                    long sleep = 1L;
                    Serializable serializable = ConnectionPool.this.dates;
                    // MONITORENTER : serializable
                    if (ConnectionPool.this.dates.isEmpty()) {
                        try {
                            ConnectionPool.this.dates.wait();
                        }
                        catch (InterruptedException e) {
                            // MONITOREXIT : serializable
                            break;
                        }
                        continue;
                    }
                    Date first = (Date)ConnectionPool.this.dates.getFirst();
                    long expected = first.getTime() + ConnectionPool.this.timeout;
                    long current = System.currentTimeMillis();
                    if (current < expected) {
                        sleep = expected - current;
                    }
                    // MONITOREXIT : serializable
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("com.diquest.ir.util.rdbms.ConnectionPool");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    serializable = clazz2;
                    // MONITORENTER : clazz2
                    if (ConnectionPool.this.pool.isEmpty()) {
                        // MONITOREXIT : serializable
                        continue;
                    }
                    long current2 = System.currentTimeMillis();
                    Iterator iterator = ConnectionPool.this.pool.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            // MONITOREXIT : serializable
                            continue block19;
                        }
                        Connection conn = (Connection)iterator.next();
                        Date date = (Date)ConnectionPool.this.map.get(conn);
                        if (date.getTime() + ConnectionPool.this.timeout > current2) continue;
                        iterator.remove();
                        ConnectionPool.this.map.remove(conn);
                        ConnectionPool.this.dates.remove(date);
                        ConnectionPool.close(conn);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("com.diquest.ir.util.rdbms.ConnectionPool");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz3 = clazz;
            // MONITORENTER : clazz
            if (!ConnectionPool.this.pool.isEmpty()) {
                long current = System.currentTimeMillis();
                Iterator iterator = ConnectionPool.this.pool.iterator();
                while (iterator.hasNext()) {
                    Connection conn = (Connection)iterator.next();
                    Date date = (Date)ConnectionPool.this.map.get(conn);
                    if (date.getTime() + ConnectionPool.this.timeout > current) continue;
                    iterator.remove();
                    ConnectionPool.this.map.remove(conn);
                    ConnectionPool.this.dates.remove(date);
                    ConnectionPool.close(conn);
                }
            }
            // MONITOREXIT : clazz3
            return;
        }
    }
}

