/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public class RdbmsProperties
implements Serializable {
    private static final long serialVersionUID = -1148115548778119854L;
    private final String url;
    private final String user;
    private final String password;
    private final String prefix;
    private final String encoding;
    private final Properties properties;
    private final boolean useSystemEncoding;
    private final boolean useEncryption;

    public RdbmsProperties(String url, String user, String password, String prefix) {
        this(url, user, password, prefix, null);
    }

    public RdbmsProperties(String url, String user, String password) {
        this(url, user, password, "IR");
    }

    public RdbmsProperties(String url, String user, String password, String prefix, String encoding) {
        this(url, user, password, prefix, encoding, null);
    }

    public RdbmsProperties(String url, String user, String password, String prefix, String encoding, Properties properties) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.prefix = prefix;
        this.encoding = encoding;
        this.useSystemEncoding = false;
        this.useEncryption = false;
        if (properties == null) {
            this.properties = new Properties();
            this.properties.put("user", user);
            this.properties.put("password", password);
        } else {
            this.properties = properties;
        }
    }

    public RdbmsProperties(String url, String user, String password, String prefix, String encoding, Properties properties, boolean useSystemEncoding) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.prefix = prefix;
        this.encoding = encoding;
        this.useSystemEncoding = useSystemEncoding;
        this.useEncryption = false;
        if (properties == null) {
            this.properties = new Properties();
            this.properties.put("user", user);
            this.properties.put("password", password);
        } else {
            this.properties = properties;
        }
    }

    public RdbmsProperties(String url, String user, String password, String prefix, String encoding, Properties properties, boolean useSystemEncoding, boolean useEncryption) {
        this.url = url;
        this.user = user;
        this.password = password;
        this.prefix = prefix;
        this.encoding = encoding;
        this.useSystemEncoding = useSystemEncoding;
        this.useEncryption = useEncryption;
        if (properties == null) {
            this.properties = new Properties();
            this.properties.put("user", user);
            this.properties.put("password", password);
        } else {
            this.properties = properties;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean getUseSystemEncoding() {
        return this.useSystemEncoding;
    }

    public boolean getUseEncryption() {
        return this.useEncryption;
    }

    public String encode(String term) {
        return this.encoding == null ? term : RdbmsProperties.encodeTo(term, this.encoding, this.useSystemEncoding);
    }

    public String decode(String term) {
        return this.encoding == null ? term : RdbmsProperties.decodeFrom(term, this.encoding, this.useSystemEncoding);
    }

    public String decode(byte[] term) throws UnsupportedEncodingException {
        return this.encoding == null ? new String(term) : new String(term, this.encoding);
    }

    private static String encodeTo(String src, String dstEnc, boolean useSystemEncoding) {
        if (src == null || dstEnc == null) {
            return src;
        }
        try {
            byte[] bytes = useSystemEncoding ? src.getBytes() : src.getBytes("UTF-8");
            return new String(bytes, dstEnc);
        }
        catch (UnsupportedEncodingException e) {
            return src;
        }
    }

    private static String decodeFrom(String src, String srcEnc, boolean useSystemEncoding) {
        if (src == null || srcEnc == null) {
            return src;
        }
        try {
            byte[] bytes = src.getBytes(srcEnc);
            if (useSystemEncoding) {
                return new String(bytes);
            }
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return src;
        }
    }
}

