/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms;

import com.diquest.ir.util.common.IrProperties;
import com.diquest.ir.util.encode.SimpleEncoder;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class RdbmsPropertiesFactory {
    private static final String IR_DB_ENCODING = "ir.db.encoding";
    private static final String IR_JDBC_DRIVER_CLASS = "ir.jdbc.driver.class";
    private static final String IR_TABLE_PREFIX = "ir.table.prefix";
    private static final String IR_JDBC_PASSWORD = "ir.jdbc.password";
    private static final String IR_JDBC_USERNAME = "ir.jdbc.username";
    private static final String IR_JDBC_URL = "ir.jdbc.url";
    private static final String IR_RDBMS_PROPERTIES = "ir.rdbms.properties";
    private static final String IR_USESYSTEM_ENCODING = "ir.usesystem.encoding";
    private static final String IR_USEENCRYPTION = "ir.useEncryption";
    public static final String DEFAULT_PREFIX = "IR";
    static RdbmsProperties properties;

    static {
        File file = new File(String.valueOf(IrProperties.getHome()) + "/rdbms", IR_RDBMS_PROPERTIES);
        try {
            properties = RdbmsPropertiesFactory.load(file);
        }
        catch (Exception e) {
            System.err.println("RdbmsPropertiesFactory loading: Fail to initialize with [" + file.getAbsolutePath() + "].");
            e.printStackTrace();
        }
    }

    public static RdbmsProperties load(File file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        try {
            Properties props = new Properties();
            props.load(fis);
            boolean useSystemEncoding = RdbmsPropertiesFactory.ensure(props.getProperty(IR_USESYSTEM_ENCODING)) != null && RdbmsPropertiesFactory.ensure(props.getProperty(IR_USESYSTEM_ENCODING)).equalsIgnoreCase("TRUE");
            boolean useEncryption = RdbmsPropertiesFactory.ensure(props.getProperty(IR_USEENCRYPTION)) != null && RdbmsPropertiesFactory.ensure(props.getProperty(IR_USEENCRYPTION)).equalsIgnoreCase("TRUE");
            String url = RdbmsPropertiesFactory.ensure(props.getProperty(IR_JDBC_URL));
            String username = RdbmsPropertiesFactory.ensure(props.getProperty(IR_JDBC_USERNAME));
            String password = RdbmsPropertiesFactory.ensure(useEncryption ? SimpleEncoder.decrypt(props.getProperty(IR_JDBC_PASSWORD)) : props.getProperty(IR_JDBC_PASSWORD));
            String prefix = RdbmsPropertiesFactory.ensure(props.getProperty(IR_TABLE_PREFIX));
            String jdbcDriver = RdbmsPropertiesFactory.ensure(props.getProperty(IR_JDBC_DRIVER_CLASS));
            String encoding = RdbmsPropertiesFactory.ensure(props.getProperty(IR_DB_ENCODING));
            if (jdbcDriver == null) {
                throw new NullPointerException(IR_JDBC_DRIVER_CLASS);
            }
            Class.forName(jdbcDriver);
            props.put("user", username);
            props.put("password", password);
            if (!useSystemEncoding && !useEncryption) {
                RdbmsProperties rdbmsProperties = RdbmsPropertiesFactory.load(url, username, password, RdbmsPropertiesFactory.isEmpty(prefix) ? DEFAULT_PREFIX : prefix, encoding, props);
                return rdbmsProperties;
            }
            RdbmsProperties rdbmsProperties = RdbmsPropertiesFactory.load(url, username, password, RdbmsPropertiesFactory.isEmpty(prefix) ? DEFAULT_PREFIX : prefix, encoding, props, useSystemEncoding, useEncryption);
            return rdbmsProperties;
        }
        finally {
            fis.close();
        }
    }

    private static String ensure(String property) {
        return property == null ? null : property.trim();
    }

    private static boolean isEmpty(String prefix) {
        return prefix == null || prefix.length() == 0;
    }

    public static RdbmsProperties load(String url, String username, String password, String tablePrefix) {
        properties = new RdbmsProperties(url, username, password, tablePrefix);
        return properties;
    }

    public static RdbmsProperties load(String url, String username, String password, String tablePrefix, String encoding) {
        properties = new RdbmsProperties(url, username, password, tablePrefix, encoding);
        return properties;
    }

    public static RdbmsProperties load(String url, String username, String password, String tablePrefix, String encoding, Properties props) {
        properties = new RdbmsProperties(url, username, password, tablePrefix, encoding, props);
        return properties;
    }

    public static RdbmsProperties load(String url, String username, String password, String tablePrefix, String encoding, Properties props, boolean useSystemEncoding, boolean useEncryption) {
        properties = new RdbmsProperties(url, username, password, tablePrefix, encoding, props, useSystemEncoding, useEncryption);
        return properties;
    }

    public static RdbmsProperties load() {
        return properties;
    }
}

