/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.column.fetch;

import com.diquest.ir.util.rdbms.column.fetch.RdbmsStreamColumnValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RdbmsBinaryStreamColumnValue
extends RdbmsStreamColumnValue {
    protected byte[] value;

    public RdbmsBinaryStreamColumnValue(String name, int index) {
        super(name, index);
    }

    public void set(ResultSet rs) throws SQLException {
        InputStream stream = rs.getBinaryStream(this.index);
        this.readFromInputStream(stream);
    }

    protected void readFromInputStream(InputStream stream) throws SQLException {
        if (stream == null) {
            this.clearValue();
            return;
        }
        try {
            try {
                byte[] buffer;
                int read;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                while ((read = stream.read(buffer = new byte[2048], 0, buffer.length)) != -1) {
                    baos.write(buffer, 0, read);
                }
                this.value = baos.toByteArray();
            }
            catch (IOException e) {
                throw new SQLException("RdbmsBinaryStreamColumnValue, Cannot read : " + e);
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public byte[] getValue() {
        return this.value;
    }
}

