/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.column.fetch;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public abstract class RdbmsColumnValue {
    protected final String name;
    protected final int index;

    protected RdbmsColumnValue(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public final String getName() {
        return this.name;
    }

    public final int getIndex() {
        return this.index;
    }

    public abstract void set(ResultSet var1) throws SQLException;

    public abstract String toString();

    public String getString() {
        return this.toString();
    }

    public char getChar() {
        String string = this.toString();
        if (string == null || string.length() == 0) {
            return '\u0000';
        }
        return string.charAt(0);
    }

    public int getInt() {
        String trimmed = this.toString().trim();
        try {
            return Integer.parseInt(trimmed);
        }
        catch (NumberFormatException e) {
            try {
                return (int)Math.round(Double.parseDouble(trimmed));
            }
            catch (NumberFormatException ee) {
                return 0;
            }
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.toString().trim());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public long getLong() {
        String trimmed = this.toString().trim();
        try {
            return Long.parseLong(trimmed);
        }
        catch (NumberFormatException e) {
            try {
                return Math.round(Double.parseDouble(trimmed));
            }
            catch (NumberFormatException ee) {
                return 0L;
            }
        }
    }

    public boolean getBoolean() {
        String trimmed = this.toString().trim();
        if ("true".equalsIgnoreCase(trimmed)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmed)) {
            return false;
        }
        if ("y".equalsIgnoreCase(trimmed)) {
            return true;
        }
        if ("n".equalsIgnoreCase(trimmed)) {
            return false;
        }
        return false;
    }

    public Date getDate() {
        return new Date(this.getLong());
    }

    public Timestamp getTimestamp() {
        return new Timestamp(this.getLong());
    }
}

