/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.column.fetch;

import com.diquest.ir.util.common.DateUtil;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RdbmsDateColumnValue
extends RdbmsColumnValue {
    private static final DateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
    private Timestamp value;

    public RdbmsDateColumnValue(String name, int index) {
        super(name, index);
    }

    public void set(ResultSet rs) throws SQLException {
        this.value = rs.getTimestamp(this.index);
    }

    public Timestamp getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        if (this.value == null) {
            return "";
        }
        DateFormat dateFormat = format;
        synchronized (dateFormat) {
            return format.format(this.value);
        }
    }

    public Date getDate() {
        if (this.value == null) {
            return DateUtil.getDefaultDate();
        }
        return this.value;
    }

    public long getLong() {
        if (this.value == null) {
            return DateUtil.getDefaultTimestamp().getTime();
        }
        return this.value.getTime();
    }

    public long getLongValue() {
        if (this.value == null) {
            return DateUtil.getDefaultTimestamp().getTime();
        }
        return this.value.getTime();
    }

    public Timestamp getTimestamp() {
        if (this.value == null) {
            return DateUtil.getDefaultTimestamp();
        }
        return this.value;
    }
}

