/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.column.fetch;

import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

abstract class RdbmsStreamColumnValue
extends RdbmsColumnValue {
    static RdbmsProperties properties = RdbmsPropertiesFactory.load();
    private char[] value = new char[8192];
    private int size = 0;

    protected RdbmsStreamColumnValue(String name, int index) {
        super(name, index);
    }

    protected void clearValue() {
        this.size = 0;
    }

    protected void read(Reader reader) throws SQLException {
        this.size = 0;
        if (reader == null) {
            return;
        }
        try {
            try {
                int want;
                int n;
                int offset = 0;
                while ((n = reader.read(this.value, offset, want = this.value.length - offset)) != -1) {
                    offset += n;
                    this.size += n;
                    if (this.size != this.value.length) continue;
                    char[] temp = new char[this.value.length * 2];
                    System.arraycopy(this.value, 0, temp, 0, this.size);
                    this.value = temp;
                }
            }
            catch (IOException e) {
                throw new SQLException("RdbmsStreamColumnValue, Cannot read : " + e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
        int i = 0;
        while (i < this.size) {
            if (this.value[i] == '\u0016') {
                this.value[i] = 32;
            }
            ++i;
        }
    }

    public String toString() {
        return properties.decode(new String(this.value, 0, this.size));
    }
}

