/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.protocol;

import com.diquest.ir.util.common.StringUtil;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsRawParameter;

public class RdbmsPagingQuery {
    private final int scale;
    private final int start;
    private final String[] columns;
    private String[] fromSet;
    private String[] orderSet;
    private String[] groupSet;
    private final RdbmsColumnParameter[] whereSet;
    private final String primaryColumn;
    private String primaryColumnExpression;
    private String fromStatement;
    private String whereStatement;
    private String groupStatement;
    private String orderStatement;

    public String toString() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ");
        sql.append(this.getSelectSet().trim()).append(' ');
        sql.append(this.getFromSet().trim()).append(' ');
        sql.append(this.getWhereString().trim()).append(' ');
        sql.append(this.getGroupString().trim()).append(' ');
        sql.append(this.getOrderString().trim()).append(' ');
        sql.append("LIMIT ").append(this.start).append(", ").append(this.scale);
        return sql.toString();
    }

    public RdbmsPagingQuery(String primaryColumn, int start, int scale, String[] columns, String from_statement, String whereStatement, String groupStatement, String orderStatement, RdbmsColumnParameter[] parameters) {
        this.primaryColumn = primaryColumn;
        this.start = start;
        this.scale = scale;
        this.columns = columns;
        this.fromStatement = from_statement;
        this.whereStatement = whereStatement;
        this.groupStatement = groupStatement;
        this.orderStatement = orderStatement;
        this.whereSet = parameters;
    }

    public RdbmsPagingQuery(String primaryColumn, int start, int scale, String[] columns, String[] fromSet, String[] orderSet, String[] groupSet, RdbmsColumnParameter[] whereSet) {
        this.primaryColumn = primaryColumn;
        this.start = start;
        this.scale = scale;
        this.columns = columns;
        this.fromSet = fromSet;
        this.orderSet = orderSet;
        this.groupSet = groupSet;
        this.whereSet = whereSet;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public int getColumnSize() {
        return this.columns.length;
    }

    public String getFromSet() {
        if (this.isNotNull(this.fromStatement)) {
            return this.fromStatement;
        }
        if (this.fromSet == null) {
            return "";
        }
        return "FROM " + StringUtil.format(this.fromSet, ',') + "\n";
    }

    public String getGroupString() {
        if (this.isNotNull(this.groupStatement)) {
            return this.groupStatement;
        }
        if (this.groupSet == null) {
            return "";
        }
        return "GROUP BY " + StringUtil.format(this.groupSet, ',') + "\n";
    }

    public String getOrderString() {
        if (this.isNotNull(this.orderStatement)) {
            return this.orderStatement;
        }
        if (this.orderSet == null) {
            return "";
        }
        return "ORDER BY " + StringUtil.format(this.orderSet, ',') + "\n";
    }

    public String getPrimaryColumn() {
        return this.primaryColumn;
    }

    public String getPrimaryColumnExpression() {
        return this.primaryColumnExpression != null ? this.primaryColumnExpression : this.primaryColumn;
    }

    public int getScale() {
        return this.scale;
    }

    public String getSelectSet() {
        if (this.columns == null) {
            return "";
        }
        return StringUtil.format(this.columns, ", ");
    }

    public int getStart() {
        return this.start;
    }

    public RdbmsColumnParameter[] getWhereSet() {
        return this.whereSet;
    }

    public String getWhereString() {
        if (this.isNotNull(this.whereStatement)) {
            return this.whereStatement;
        }
        StringBuffer where = new StringBuffer();
        if (this.whereSet != null && this.whereSet.length > 0) {
            where.append("WHERE ");
            int i = 0;
            while (i < this.whereSet.length) {
                String whereToken = this.whereSet[i].getName();
                if (this.whereSet[i] instanceof RdbmsRawParameter) {
                    where.append(whereToken).append(" ? ");
                } else {
                    int likeIndex = whereToken.toUpperCase().indexOf("LIKE");
                    if (likeIndex > -1) {
                        where.append(whereToken).append(" ? ");
                    } else {
                        where.append(whereToken).append(" = ? ");
                    }
                }
                if (i != this.whereSet.length - 1) {
                    where.append(" AND ");
                }
                ++i;
            }
            where.append("\n");
        }
        return where.toString();
    }

    public boolean isNotNull(String statement) {
        return statement != null && !"".equals(statement.trim());
    }

    public final void setPrimaryColumnExpression(String primaryColumnExpression) {
        this.primaryColumnExpression = primaryColumnExpression;
    }
}

