/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.ir.util.rdbms.column.fetch.RdbmsBytesColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsCharStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.driver.AltibaseDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporterFamily;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class AltibaseSupporter
extends RdbmsSupporter
implements RdbmsSupporterFamily {
    public static final String VALIDATION_SQL = "select sysdate";

    public AltibaseSupporter() {
        super(new AltibaseDriver());
    }

    public int executeUpdate(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        boolean autoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        int result = super.executeUpdate(conn, query);
        conn.commit();
        conn.setAutoCommit(autoCommit);
        return result;
    }

    public RdbmsColumnValue[] fetchItem(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        boolean autoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        RdbmsColumnValue[] member_column_values = super.fetchItem(conn, query);
        conn.commit();
        conn.setAutoCommit(autoCommit);
        return member_column_values;
    }

    public List fetchItems(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        boolean autoCommit = conn.getAutoCommit();
        conn.setAutoCommit(false);
        List list = super.fetchItems(conn, query);
        conn.commit();
        conn.setAutoCommit(autoCommit);
        return list;
    }

    public String generateCriteriaQuery(RdbmsPagingQuery info) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT * FROM\n");
        query.append("(");
        query.append("SELECT ROWNUM AS RNUM, A.* FROM (\n");
        query.append("  SELECT ");
        query.append(String.valueOf(info.getSelectSet()) + "\n");
        query.append("  " + info.getFromSet());
        query.append("  " + info.getWhereString());
        query.append("  " + info.getGroupString());
        query.append("  " + info.getOrderString());
        query.append(") A \n  ");
        query.append("WHERE ROWNUM < " + (info.getStart() + info.getScale()) + "\n");
        query.append(") WHERE RNUM > " + (info.getStart() - 1));
        return query.toString();
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 2005: {
                return new RdbmsCharStreamColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return new RdbmsBytesColumnValue(name, index);
            }
        }
        return new RdbmsStringColumnValue(name, index);
    }

    public int getRowSkip() {
        return 0;
    }

    public RdbmsSupporter getMatched(Connection conn) throws SQLException {
        if (this.match(conn)) {
            return this;
        }
        return null;
    }

    public String getValidateSql() {
        return VALIDATION_SQL;
    }
}

