/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.commons.type.StringUtil;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsCharStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.driver.CubridDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporterFamily;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CubridSupporter
extends RdbmsSupporter
implements RdbmsSupporterFamily {
    public static final String VALIDATION_SQL = "select 1 from db_root";
    private final String[] targetTables;
    private static final String EMPTY_STRING = "";
    private List reservedQueryList;

    public CubridSupporter() {
        super(new CubridDriver());
        this.targetTables = new String[]{String.valueOf(this.properties.getPrefix()) + "_JOB_LOG", String.valueOf(this.properties.getPrefix()) + "_TEST_QUERY", String.valueOf(this.properties.getPrefix()) + "_FEEDBACK", String.valueOf(this.properties.getPrefix()) + "_CATEGORY_RANKING", String.valueOf(this.properties.getPrefix()) + "_DOCUMENT_RANKING"};
        this.reservedQueryList = new ArrayList();
    }

    public RdbmsColumnValue[] fetchItem(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        PreparedStatement pstmt = null;
        conn.setAutoCommit(false);
        pstmt = conn.prepareStatement(this.properties.encode(this.replaceReservedWord(query.getSql())));
        this.setPreparedStatement(pstmt, query.getParameters());
        ResultSet rs = pstmt.executeQuery();
        RdbmsColumnValue[] columnValues = new RdbmsColumnValue[rs.getMetaData().getColumnCount()];
        try {
            try {
                RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
                if (rs.next()) {
                    int i = 0;
                    while (i < columnValues.length) {
                        int column_index = i + 1;
                        int columnType = rs.getMetaData().getColumnType(column_index);
                        String columnName = rs.getMetaData().getColumnName(column_index);
                        columnValues[i] = rdbmsSupporter.getDbColumnValue(columnName, i + 1, columnType);
                        columnValues[i].set(rs);
                        ++i;
                    }
                }
                conn.commit();
                conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                conn.rollback();
                e.printStackTrace();
                ConnectionFactory.release(rs, pstmt);
            }
        }
        finally {
            ConnectionFactory.release(rs, pstmt);
        }
        return columnValues;
    }

    public List fetchItems(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        ArrayList<RdbmsColumnValue[]> items;
        block9: {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            items = new ArrayList<RdbmsColumnValue[]>();
            conn.setAutoCommit(false);
            try {
                try {
                    pstmt = conn.prepareStatement(this.properties.encode(this.replaceReservedWord(query.getSql())));
                    this.setPreparedStatement(pstmt, query.getParameters());
                    rs = pstmt.executeQuery();
                    RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
                    int columnCount = rs.getMetaData().getColumnCount();
                    int[] columnTypes = new int[columnCount];
                    String[] columnNames = new String[columnCount];
                    if (rs.next()) {
                        RdbmsColumnValue[] columnValues = new RdbmsColumnValue[columnCount];
                        int i = 0;
                        while (i < columnValues.length) {
                            columnTypes[i] = rs.getMetaData().getColumnType(i + 1);
                            columnNames[i] = rs.getMetaData().getColumnName(i + 1);
                            columnValues[i] = rdbmsSupporter.getDbColumnValue(columnNames[i], i + 1, columnTypes[i]);
                            columnValues[i].set(rs);
                            ++i;
                        }
                        items.add(columnValues);
                        while (rs.next()) {
                            columnValues = new RdbmsColumnValue[columnCount];
                            i = 0;
                            while (i < columnValues.length) {
                                columnValues[i] = rdbmsSupporter.getDbColumnValue(columnNames[i], i + 1, columnTypes[i]);
                                columnValues[i].set(rs);
                                ++i;
                            }
                            items.add(columnValues);
                        }
                    }
                    conn.commit();
                    conn.setAutoCommit(true);
                }
                catch (SQLException e) {
                    conn.rollback();
                    e.printStackTrace();
                    ConnectionFactory.release(rs, pstmt);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                ConnectionFactory.release(rs, pstmt);
                throw throwable;
            }
            ConnectionFactory.release(rs, pstmt);
        }
        return items;
    }

    public List fetchCriteria(Connection conn, RdbmsPagingQuery query) throws SQLException {
        ArrayList<RdbmsColumnValue[]> items = new ArrayList<RdbmsColumnValue[]>();
        String sql = this.generateCriteriaQuery(query);
        PreparedStatement pstmt = null;
        pstmt = conn.prepareStatement(this.properties.encode(this.replaceReservedWord(sql)));
        this.setPreparedStatement(pstmt, query.getWhereSet());
        ResultSet rs = pstmt.executeQuery();
        rs.setFetchSize(query.getScale());
        try {
            RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
            int skip = this.getRowSkip();
            while (rs.next()) {
                if (skip != 0) {
                    --skip;
                    continue;
                }
                RdbmsColumnValue[] columnValues = new RdbmsColumnValue[query.getColumns().length];
                int i = 0;
                while (i < columnValues.length) {
                    String column = query.getColumns()[i].toUpperCase();
                    int resultset_column_index = i + 1;
                    String rs_column_name = rs.getMetaData().getColumnName(resultset_column_index).toUpperCase();
                    if (!column.equalsIgnoreCase(rs_column_name)) {
                        int as_index = column.indexOf("AS");
                        int rs_column_index = column.indexOf(rs_column_name);
                        if (as_index < 0 || rs_column_index < 0 || as_index > rs_column_index) {
                            rs_column_name = rs.getMetaData().getColumnName(++resultset_column_index).toUpperCase();
                        }
                    }
                    int columnType = rs.getMetaData().getColumnType(resultset_column_index);
                    columnValues[i] = rdbmsSupporter.getDbColumnValue(rs_column_name, resultset_column_index, columnType);
                    columnValues[i].set(rs);
                    ++i;
                }
                items.add(columnValues);
                if (query.getScale() != items.size()) continue;
                break;
            }
        }
        finally {
            ConnectionFactory.release(rs, pstmt);
        }
        return items;
    }

    public int executeUpdate(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        PreparedStatement pstmt = null;
        pstmt = conn.prepareStatement(this.properties.encode(this.replaceReservedWord(query.getSql())));
        int result = -1;
        try {
            this.setPreparedStatement(pstmt, query.getParameters());
            result = pstmt.executeUpdate();
        }
        finally {
            ConnectionFactory.release(pstmt);
        }
        return result;
    }

    public int executeUpdate(Connection conn, String sql) throws SQLException {
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, null);
        return this.executeUpdate(conn, query);
    }

    private boolean isTargetTable(String query) {
        return this.isFromTarget(query) || this.isInsertTarget(query) || this.isUpdateTarget(query) || this.isDeleteTarget(query);
    }

    private boolean isFromTarget(String query) {
        String fromStr = this.parseFrom(query);
        int i = 0;
        while (i < this.targetTables.length) {
            if (fromStr.equalsIgnoreCase(this.targetTables[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isInsertTarget(String query) {
        String insertStr = this.parseInto(query);
        int i = 0;
        while (i < this.targetTables.length) {
            if (insertStr.equalsIgnoreCase(this.targetTables[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isUpdateTarget(String query) {
        String updateStr = this.parseUpdate(query);
        int i = 0;
        while (i < this.targetTables.length) {
            if (updateStr.equalsIgnoreCase(this.targetTables[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDeleteTarget(String query) {
        String deleteStr = this.parseDelete(query);
        int i = 0;
        while (i < this.targetTables.length) {
            if (deleteStr.equalsIgnoreCase(this.targetTables[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String parseFrom(String query) {
        int fromOffset = query.indexOf(" FROM ");
        if (fromOffset == -1) {
            fromOffset = query.indexOf(" from ");
        }
        if (fromOffset == -1) {
            return EMPTY_STRING;
        }
        if (query.indexOf(" ", fromOffset + 6) == -1) {
            return query.substring(fromOffset + 6);
        }
        return query.substring(fromOffset + 6, query.indexOf(" ", fromOffset + 6)).trim();
    }

    private String parseInto(String query) {
        int intoOffset = query.indexOf("INSERT INTO ");
        if (intoOffset == -1) {
            intoOffset = query.indexOf("insert into ");
        }
        if (intoOffset == -1) {
            return EMPTY_STRING;
        }
        if (query.indexOf(" ", intoOffset + 12) == -1) {
            return query.substring(intoOffset + 12);
        }
        return query.substring(intoOffset + 12, query.indexOf(" ", intoOffset + 12)).trim();
    }

    private String parseUpdate(String query) {
        int updateOffset = query.indexOf("UPDATE ");
        if (updateOffset == -1) {
            updateOffset = query.indexOf("update ");
        }
        if (updateOffset == -1) {
            return EMPTY_STRING;
        }
        if (query.indexOf(" ", updateOffset + 7) == -1) {
            return query.substring(updateOffset + 7);
        }
        return query.substring(updateOffset + 7, query.indexOf(" ", updateOffset + 7)).trim();
    }

    private String parseDelete(String query) {
        int deleteOffset = query.indexOf("DELETE FROM ");
        if (deleteOffset == -1) {
            deleteOffset = query.indexOf("delete from ");
        }
        if (deleteOffset == -1) {
            return EMPTY_STRING;
        }
        if (query.indexOf(" ", deleteOffset + 12) == -1) {
            return query.substring(deleteOffset + 12);
        }
        return query.substring(deleteOffset + 12, query.indexOf(" ", deleteOffset + 12)).trim();
    }

    private String replaceReservedWord(String query) {
        String[][] words = new String[][]{{" AS MIN", " AS MIN_LAST_UPDATED"}, {" QUERY=", " \"QUERY\"="}, {" QUERY,", " \"QUERY\","}, {" METHOD=", " \"METHOD\"="}, {" METHOD,", " \"METHOD\","}, {" TYPE=", " \"TYPE\"="}, {" TYPE,", " \"TYPE\","}};
        String converted = query;
        int i = 0;
        while (i < words.length) {
            converted = StringUtil.replace((String)converted, (String)words[i][0], (String)words[i][1]);
            ++i;
        }
        return converted;
    }

    private boolean hasReservedQuery(String query) {
        if (this.reservedQueryList.isEmpty()) {
            this.setReservedQueryMap();
        }
        return this.reservedQueryList.contains(query.trim());
    }

    private void setReservedQueryMap() {
        String PREFIX = this.properties.getPrefix();
        this.reservedQueryList.add("SELECT MIN(LAST_UPDATED) AS MIN FROM " + PREFIX + "_JOB_LOG  WHERE  JOB_STATUS   = 'A'  AND JOB_ENABLE = 'E'");
        this.reservedQueryList.add("INSERT INTO " + PREFIX + "_TEST_QUERY (COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE) VALUES (?, ?, ?, ?, ?, ?, ?, ?  )");
        this.reservedQueryList.add("UPDATE " + PREFIX + "_TEST_QUERY SET TITLE=?, SUMMARY=?, THUMBNAIL=?, DISPLAY_REMOVED=?, QUERY=?, REG_DATE=? WHERE COLLECTION_ID = ? AND QUERY_ID = ? ");
        this.reservedQueryList.add("SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + PREFIX + "_TEST_QUERY WHERE COLLECTION_ID = ? AND QUERY_ID = ?");
        this.reservedQueryList.add("SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + PREFIX + "_TEST_QUERY WHERE COLLECTION_ID = ?");
        this.reservedQueryList.add("SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + PREFIX + "_TEST_QUERY");
        this.reservedQueryList.add("SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + PREFIX + "_TEST_QUERY ORDER BY QUERY_ID ASC");
        this.reservedQueryList.add("SELECT COLLECTION_ID, QUERY_ID, TITLE, SUMMARY, THUMBNAIL, DISPLAY_REMOVED, QUERY, REG_DATE FROM " + PREFIX + "_TEST_QUERY WHERE COLLECTION_ID = ? ORDER BY QUERY_ID ASC");
        this.reservedQueryList.add("SELECT METHOD, COLLECTION_ID, PROFILE_ID, KEYWORD, STR_PARAM1, STR_PARAM2, STR_PARAM3, NUM_PARAM1, NUM_PARAM2, NUM_PARAM3, REG_DATE FROM " + PREFIX + "_FEEDBACK WHERE METHOD=? AND REG_DATE BETWEEN ? AND ? ORDER BY REG_DATE ASC");
    }

    public String generateCriteriaQuery(RdbmsPagingQuery info) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT TEMP_.* FROM ( \n");
        sql.append(" SELECT ROWNUM AS ROW_, TEMP_INNER.* \n ");
        sql.append(" FROM ( \n");
        sql.append("\t SELECT \n");
        sql.append("\t").append(info.getSelectSet()).append("\n");
        sql.append("\t").append(info.getFromSet()).append("\n");
        sql.append("\t").append(info.getWhereString()).append("\n");
        sql.append("\t").append(info.getGroupString()).append("\n");
        sql.append("\t").append(info.getOrderString()).append("\n");
        sql.append(" ) as TEMP_INNER ");
        sql.append(" ) as TEMP_ \n");
        sql.append("WHERE ROW_ BETWEEN ");
        sql.append(info.getStart()).append(" AND ").append(info.getStart() - 1 + info.getScale());
        return sql.toString();
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case -5: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return new RdbmsStringColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case -1: 
            case 2005: {
                return new RdbmsCharStreamColumnValue(name, index);
            }
        }
        return new RdbmsBinaryStreamColumnValue(name, index);
    }

    public int getRowSkip() {
        return 0;
    }

    public RdbmsSupporter getMatched(Connection conn) throws SQLException {
        if (this.match(conn)) {
            return this;
        }
        return null;
    }

    public String getValidateSql() {
        return VALIDATION_SQL;
    }
}

