/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsCharStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDoubleColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsIntColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.driver.Oracle9PlusDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;

public class Oracle9PlusSupporter
extends RdbmsSupporter {
    public static final String VALIDATION_SQL = "select 1 from dual";

    public Oracle9PlusSupporter() {
        super(new Oracle9PlusDriver());
    }

    public String generateCriteriaQuery(RdbmsPagingQuery pagingInfo) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM\n");
        sql.append("(");
        sql.append("SELECT ROWNUM AS RNUM, A.* FROM (\n");
        sql.append("  SELECT ");
        sql.append(String.valueOf(pagingInfo.getSelectSet()) + "\n");
        sql.append("  " + pagingInfo.getFromSet());
        sql.append("  " + pagingInfo.getWhereString());
        sql.append("  " + pagingInfo.getGroupString());
        sql.append("  " + pagingInfo.getOrderString());
        sql.append(") A \n  ");
        sql.append("WHERE ROWNUM <= " + (pagingInfo.getStart() + pagingInfo.getScale()) + "\n");
        sql.append(") WHERE RNUM > " + (pagingInfo.getStart() - 1));
        return sql.toString();
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return new RdbmsIntColumnValue(name, index);
            }
            case 6: 
            case 8: {
                return new RdbmsDoubleColumnValue(name, index);
            }
            case -5: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: {
                return new RdbmsStringColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case -1: 
            case 2005: {
                return new RdbmsCharStreamColumnValue(name, index);
            }
        }
        return new RdbmsBinaryStreamColumnValue(name, index);
    }

    public int getRowSkip() {
        return 0;
    }

    public String getValidateSql() {
        return VALIDATION_SQL;
    }
}

