/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsCharStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDoubleColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsIntColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.driver.PostgresDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporter;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporterFamily;
import java.sql.Connection;
import java.sql.SQLException;

public class PostgresSupporter
extends RdbmsSupporter
implements RdbmsSupporterFamily {
    public static final String VALIDATION_SQL = "select 1";

    public PostgresSupporter() {
        super(new PostgresDriver());
    }

    public String generateCriteriaQuery(RdbmsPagingQuery info) {
        StringBuffer query = new StringBuffer();
        query.append("SELECT ");
        query.append(info.getSelectSet()).append(' ');
        query.append(info.getFromSet()).append(' ');
        query.append(info.getWhereString()).append(' ');
        query.append(info.getGroupString()).append(' ');
        query.append(info.getOrderString()).append(' ');
        query.append("LIMIT " + info.getScale() + " OFFSET " + (info.getStart() - 1));
        return query.toString();
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return new RdbmsIntColumnValue(name, index);
            }
            case 6: 
            case 8: {
                return new RdbmsDoubleColumnValue(name, index);
            }
            case -5: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 12: {
                return new RdbmsStringColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case -1: 
            case 2005: {
                return new RdbmsCharStreamColumnValue(name, index);
            }
        }
        return new RdbmsBinaryStreamColumnValue(name, index);
    }

    public int getRowSkip() {
        return 0;
    }

    public RdbmsSupporter getMatched(Connection conn) throws SQLException {
        if (this.match(conn)) {
            return this;
        }
        return null;
    }

    public String getValidateSql() {
        return VALIDATION_SQL;
    }
}

