/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.util.rdbms.supporter;

import com.diquest.ir.util.rdbms.ConnectionFactory;
import com.diquest.ir.util.rdbms.RdbmsProperties;
import com.diquest.ir.util.rdbms.RdbmsPropertiesFactory;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsBinaryStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsCharStreamColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsDateColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsIntColumnValue;
import com.diquest.ir.util.rdbms.column.fetch.RdbmsStringColumnValue;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsBinaryStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsCharStreamColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsIntColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsLongColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsOffsetDateColumnParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsRawParameter;
import com.diquest.ir.util.rdbms.column.parameter.RdbmsStringColumnParameter;
import com.diquest.ir.util.rdbms.driver.RdbmsDriver;
import com.diquest.ir.util.rdbms.protocol.RdbmsGeneralQuery;
import com.diquest.ir.util.rdbms.protocol.RdbmsPagingQuery;
import com.diquest.ir.util.rdbms.supporter.AltibaseSupporter;
import com.diquest.ir.util.rdbms.supporter.CubridSupporter;
import com.diquest.ir.util.rdbms.supporter.DB2Supporter;
import com.diquest.ir.util.rdbms.supporter.InformixSupporters;
import com.diquest.ir.util.rdbms.supporter.MariaDBSupporter;
import com.diquest.ir.util.rdbms.supporter.MySQLSupporter;
import com.diquest.ir.util.rdbms.supporter.OracleSupporters;
import com.diquest.ir.util.rdbms.supporter.PostgresSupporter;
import com.diquest.ir.util.rdbms.supporter.RdbmsSupporterFamily;
import com.diquest.ir.util.rdbms.supporter.SqlServerSupporters;
import com.diquest.ir.util.rdbms.supporter.TiberoSupporter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;

public abstract class RdbmsSupporter {
    RdbmsDriver driver;
    RdbmsProperties properties = RdbmsPropertiesFactory.load();
    private static final RdbmsSupporterFamily[] FACTORIES = new RdbmsSupporterFamily[]{new OracleSupporters(), new SqlServerSupporters(), new MySQLSupporter(), new PostgresSupporter(), new DB2Supporter(), new InformixSupporters(), new TiberoSupporter(), new CubridSupporter(), new MariaDBSupporter(), new AltibaseSupporter()};

    public RdbmsSupporter(RdbmsDriver driver) {
        this.driver = driver;
    }

    public abstract String generateCriteriaQuery(RdbmsPagingQuery var1);

    public abstract String getValidateSql();

    public abstract int getRowSkip();

    public boolean match(Connection conn) throws SQLException {
        return this.driver.match(conn);
    }

    public boolean isSqlServer() {
        return false;
    }

    public boolean isSubquerySupported() {
        return true;
    }

    public String getSubqueryAliasIndicator() {
        return "";
    }

    public String toString() {
        return this.driver.toString();
    }

    public boolean isBatchUpdatable() {
        return true;
    }

    public List fetchCriteria(Connection conn, RdbmsPagingQuery query) throws SQLException {
        ArrayList<RdbmsColumnValue[]> items = new ArrayList<RdbmsColumnValue[]>();
        String sql = this.generateCriteriaQuery(query);
        PreparedStatement pstmt = conn.prepareStatement(this.properties.encode(sql));
        this.setPreparedStatement(pstmt, query.getWhereSet());
        ResultSet rs = pstmt.executeQuery();
        rs.setFetchSize(query.getScale());
        try {
            RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
            int skip = this.getRowSkip();
            while (rs.next()) {
                if (skip != 0) {
                    --skip;
                    continue;
                }
                RdbmsColumnValue[] columnValues = new RdbmsColumnValue[query.getColumns().length];
                int i = 0;
                while (i < columnValues.length) {
                    String column = query.getColumns()[i].toUpperCase();
                    int resultset_column_index = i + 1;
                    String rs_column_name = rs.getMetaData().getColumnName(resultset_column_index).toUpperCase();
                    if (!column.equalsIgnoreCase(rs_column_name)) {
                        int as_index = column.indexOf("AS");
                        int rs_column_index = column.indexOf(rs_column_name);
                        if (as_index < 0 || rs_column_index < 0 || as_index > rs_column_index) {
                            rs_column_name = rs.getMetaData().getColumnName(++resultset_column_index).toUpperCase();
                        }
                    }
                    int columnType = rs.getMetaData().getColumnType(resultset_column_index);
                    columnValues[i] = rdbmsSupporter.getDbColumnValue(rs_column_name, resultset_column_index, columnType);
                    columnValues[i].set(rs);
                    ++i;
                }
                items.add(columnValues);
                if (query.getScale() != items.size()) continue;
                break;
            }
        }
        finally {
            ConnectionFactory.release(rs, pstmt);
        }
        return items;
    }

    public RdbmsColumnValue[] fetchItem(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement(this.properties.encode(query.getSql()));
        this.setPreparedStatement(pstmt, query.getParameters());
        ResultSet rs = pstmt.executeQuery();
        RdbmsColumnValue[] columnValues = new RdbmsColumnValue[rs.getMetaData().getColumnCount()];
        try {
            RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
            if (rs.next()) {
                int i = 0;
                while (i < columnValues.length) {
                    int column_index = i + 1;
                    int columnType = rs.getMetaData().getColumnType(column_index);
                    String columnName = rs.getMetaData().getColumnName(column_index);
                    columnValues[i] = rdbmsSupporter.getDbColumnValue(columnName, i + 1, columnType);
                    columnValues[i].set(rs);
                    ++i;
                }
            }
        }
        finally {
            ConnectionFactory.release(rs, pstmt);
        }
        return columnValues;
    }

    public List fetchItems(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<RdbmsColumnValue[]> items = new ArrayList<RdbmsColumnValue[]>();
        try {
            pstmt = conn.prepareStatement(this.properties.encode(query.getSql()));
            this.setPreparedStatement(pstmt, query.getParameters());
            rs = pstmt.executeQuery();
            RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
            int columnCount = rs.getMetaData().getColumnCount();
            int[] columnTypes = new int[columnCount];
            String[] columnNames = new String[columnCount];
            if (rs.next()) {
                RdbmsColumnValue[] columnValues = new RdbmsColumnValue[columnCount];
                int i = 0;
                while (i < columnValues.length) {
                    columnTypes[i] = rs.getMetaData().getColumnType(i + 1);
                    columnNames[i] = rs.getMetaData().getColumnName(i + 1);
                    columnValues[i] = rdbmsSupporter.getDbColumnValue(columnNames[i], i + 1, columnTypes[i]);
                    columnValues[i].set(rs);
                    ++i;
                }
                items.add(columnValues);
                while (rs.next()) {
                    columnValues = new RdbmsColumnValue[columnCount];
                    i = 0;
                    while (i < columnValues.length) {
                        columnValues[i] = rdbmsSupporter.getDbColumnValue(columnNames[i], i + 1, columnTypes[i]);
                        columnValues[i].set(rs);
                        ++i;
                    }
                    items.add(columnValues);
                }
            }
        }
        catch (Throwable throwable) {
            ConnectionFactory.release(rs, pstmt);
            throw throwable;
        }
        ConnectionFactory.release(rs, pstmt);
        return items;
    }

    public Enumeration fetchItemsRealTime(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement(this.properties.encode(query.getSql()));
        this.setPreparedStatement(pstmt, query.getParameters());
        final ResultSet rs = pstmt.executeQuery();
        final RdbmsSupporter rdbmsSupporter = RdbmsSupporter.createRdbmsSupporter(conn);
        final int columnCount = rs.getMetaData().getColumnCount();
        return new Enumeration(pstmt){
            final ResultSet _rs;
            final PreparedStatement _pstmt;
            boolean error;
            boolean flag;
            boolean lastAnswer;
            int[] columnTypes;
            String[] columnNames;
            boolean checked;
            boolean closed;
            {
                this._rs = resultSet;
                this._pstmt = preparedStatement;
                this.error = false;
                this.flag = false;
                this.lastAnswer = false;
                this.columnTypes = new int[n];
                this.columnNames = new String[n];
                this.checked = false;
                this.closed = false;
            }

            public boolean hasMoreElements() {
                if (this.error) {
                    return false;
                }
                if (this.flag) {
                    return this.lastAnswer;
                }
                this.flag = true;
                try {
                    boolean bl = this.lastAnswer = this._rs.next();
                    return bl;
                }
                catch (SQLException e) {
                    this.error = true;
                    this.close();
                    return false;
                }
                finally {
                    if (!this.lastAnswer) {
                        this.close();
                    }
                }
            }

            public Object nextElement() {
                if (this.error) {
                    throw new NoSuchElementException();
                }
                if (this.flag) {
                    this.flag = false;
                } else {
                    try {
                        boolean hasNext = this._rs.next();
                        if (!hasNext) {
                            this.close();
                            throw new NoSuchElementException();
                        }
                    }
                    catch (SQLException e) {
                        this.error = true;
                        this.close();
                        throw new NoSuchElementException();
                    }
                }
                RdbmsColumnValue[] columnValues = new RdbmsColumnValue[columnCount];
                try {
                    int i;
                    if (!this.checked) {
                        i = 0;
                        while (i < columnValues.length) {
                            this.columnTypes[i] = rs.getMetaData().getColumnType(i + 1);
                            this.columnNames[i] = rs.getMetaData().getColumnName(i + 1);
                            ++i;
                        }
                        this.checked = true;
                    }
                    i = 0;
                    while (i < columnValues.length) {
                        columnValues[i] = rdbmsSupporter.getDbColumnValue(this.columnNames[i], i + 1, this.columnTypes[i]);
                        columnValues[i].set(rs);
                        ++i;
                    }
                }
                catch (SQLException e) {
                    this.close();
                    throw new NoSuchElementException();
                }
                return columnValues;
            }

            protected void finalize() throws Throwable {
                try {
                    this.close();
                }
                finally {
                    super.finalize();
                }
            }

            private void close() {
                if (!this.closed) {
                    ConnectionFactory.release(this._rs, this._pstmt);
                    this.closed = true;
                }
            }
        };
    }

    protected void setPreparedStatement(PreparedStatement pstmt, RdbmsColumnParameter[] whereSet) throws SQLException {
        if (whereSet == null) {
            return;
        }
        int i = 0;
        while (i < whereSet.length) {
            RdbmsColumnParameter parameter = whereSet[i];
            if (parameter instanceof RdbmsStringColumnParameter) {
                RdbmsStringColumnParameter stringParam = (RdbmsStringColumnParameter)parameter;
                pstmt.setString(stringParam.getIndex(), this.properties.encode(stringParam.getValue()));
            } else if (parameter instanceof RdbmsIntColumnParameter) {
                RdbmsIntColumnParameter intParam = (RdbmsIntColumnParameter)parameter;
                pstmt.setInt(intParam.getIndex(), intParam.getValue());
            } else if (parameter instanceof RdbmsLongColumnParameter) {
                RdbmsLongColumnParameter longParam = (RdbmsLongColumnParameter)parameter;
                pstmt.setLong(longParam.getIndex(), longParam.getValue());
            } else if (parameter instanceof RdbmsDateColumnParameter) {
                RdbmsDateColumnParameter dateParam = (RdbmsDateColumnParameter)parameter;
                pstmt.setTimestamp(dateParam.getIndex(), dateParam.getValue());
            } else if (parameter instanceof RdbmsBinaryStreamColumnParameter) {
                RdbmsBinaryStreamColumnParameter binaryParam = (RdbmsBinaryStreamColumnParameter)parameter;
                pstmt.setBinaryStream(binaryParam.getIndex(), (InputStream)new ByteArrayInputStream(binaryParam.getValue()), binaryParam.getValue().length);
            } else if (parameter instanceof RdbmsCharStreamColumnParameter) {
                RdbmsCharStreamColumnParameter charParam = (RdbmsCharStreamColumnParameter)parameter;
                char[] converted = this.properties.encode(new String(charParam.getValue())).toCharArray();
                pstmt.setCharacterStream(charParam.getIndex(), (Reader)new CharArrayReader(converted), converted.length);
            } else if (parameter instanceof RdbmsRawParameter) {
                RdbmsRawParameter param = (RdbmsRawParameter)parameter;
                pstmt.setString(param.getIndex(), this.properties.encode(param.getValue()));
            } else if (parameter instanceof RdbmsOffsetDateColumnParameter) {
                RdbmsOffsetDateColumnParameter offsetDateParam = (RdbmsOffsetDateColumnParameter)parameter;
                pstmt.setTimestamp(offsetDateParam.getIndex(), offsetDateParam.getValue());
            } else {
                throw new IllegalArgumentException(String.valueOf(i) + "th argument is unknown type :[" + parameter.getClass().getName() + "]");
            }
            ++i;
        }
    }

    public int executeUpdate(Connection conn, RdbmsGeneralQuery query) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement(this.properties.encode(query.getSql()));
        int result = -1;
        try {
            this.setPreparedStatement(pstmt, query.getParameters());
            result = pstmt.executeUpdate();
        }
        finally {
            ConnectionFactory.release(pstmt);
        }
        return result;
    }

    public int executeUpdate(Connection conn, String sql) throws SQLException {
        RdbmsGeneralQuery query = new RdbmsGeneralQuery(sql, null);
        return this.executeUpdate(conn, query);
    }

    public RdbmsColumnValue getDbColumnValue(String name, int index, int type) {
        switch (type) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                return new RdbmsIntColumnValue(name, index);
            }
            case -5: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 12: {
                return new RdbmsStringColumnValue(name, index);
            }
            case 91: 
            case 92: 
            case 93: {
                return new RdbmsDateColumnValue(name, index);
            }
            case -1: 
            case 2005: {
                return new RdbmsCharStreamColumnValue(name, index);
            }
        }
        return new RdbmsBinaryStreamColumnValue(name, index);
    }

    public static synchronized RdbmsSupporter createRdbmsSupporter(Connection conn) throws SQLException {
        if (FACTORIES.length > 0) {
            int i = 0;
            while (i < FACTORIES.length) {
                RdbmsSupporterFamily factory = FACTORIES[i];
                RdbmsSupporter matched = factory.getMatched(conn);
                if (matched != null) {
                    if (i != 0) {
                        RdbmsSupporterFamily temp = FACTORIES[i];
                        RdbmsSupporter.FACTORIES[i] = FACTORIES[0];
                        RdbmsSupporter.FACTORIES[0] = temp;
                    }
                    return matched.getInstance();
                }
                ++i;
            }
        }
        return null;
    }

    public RdbmsSupporter getInstance() {
        return this;
    }

    public void setProperties(RdbmsProperties properties) {
        this.properties = properties;
    }
}

